/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.data;

import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public final class EnderChestData {
    public static final int SMALL_SIZE = 27;
    public static final int LARGE_SIZE = 54;
    private final TrackingContainer container;
    private final Container smallView;
    private Runnable changeListener = () -> {};
    private boolean hasLargeEnderChest;
    private String lastKnownUsername;

    public EnderChestData() {
        this.container = new TrackingContainer(54);
        this.smallView = new SlotRangeContainer(this.container, 0, 27);
    }

    public Container getSmallContainer() {
        return this.smallView;
    }

    public SimpleContainer getLargeContainer() {
        return this.container;
    }

    public boolean hasLargeEnderChest() {
        return this.hasLargeEnderChest;
    }

    public void setHasLargeEnderChest(boolean hasLargeEnderChest) {
        if (this.hasLargeEnderChest != hasLargeEnderChest) {
            this.hasLargeEnderChest = hasLargeEnderChest;
            this.notifyChanged();
        }
    }

    public String getLastKnownUsername() {
        return this.lastKnownUsername;
    }

    public void updateLastKnownUsername(String username) {
        if (username == null || Objects.equals(this.lastKnownUsername, username)) {
            return;
        }
        this.lastKnownUsername = username;
        this.notifyChanged();
    }

    public void setChangeListener(Runnable listener) {
        this.changeListener = listener != null ? listener : () -> {};
        this.container.setListener(this.changeListener);
    }

    public void load(CompoundTag tag, HolderLookup.Provider registries) {
        this.hasLargeEnderChest = tag.getBooleanOr("HasLarge", false);
        this.lastKnownUsername = tag.getString("LastKnownName").orElse(null);
        this.container.clearContent();
        tag.getCompound("Items").ifPresentOrElse(compound -> EnderChestData.readContainerRange(compound, this.container, registries, 0, 54), () -> tag.getCompound("Large").ifPresentOrElse(compound -> EnderChestData.readContainerRange(compound, this.container, registries, 0, 54), () -> tag.getCompound("Small").ifPresent(compound -> EnderChestData.readContainerRange(compound, this.container, registries, 0, 27))));
    }

    public CompoundTag save(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("HasLarge", this.hasLargeEnderChest);
        if (this.lastKnownUsername != null && !this.lastKnownUsername.isBlank()) {
            tag.putString("LastKnownName", this.lastKnownUsername);
        }
        CompoundTag items = EnderChestData.writeContainerRange(this.container, registries, 0, 54);
        tag.put("Items", (Tag)items);
        tag.put("Large", (Tag)items.copy());
        tag.put("Small", (Tag)EnderChestData.writeContainerRange(this.container, registries, 0, 27));
        return tag;
    }

    private void notifyChanged() {
        this.changeListener.run();
    }

    private static void readContainerRange(CompoundTag tag, SimpleContainer container, HolderLookup.Provider registries, int start, int size) {
        NonNullList items = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        ValueInput input = TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)registries, (CompoundTag)tag);
        ContainerHelper.loadAllItems((ValueInput)input, (NonNullList)items);
        for (int slot = 0; slot < size; ++slot) {
            container.setItem(start + slot, (ItemStack)items.get(slot));
        }
    }

    private static CompoundTag writeContainerRange(SimpleContainer container, HolderLookup.Provider registries, int start, int size) {
        NonNullList items = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        for (int slot = 0; slot < size; ++slot) {
            items.set(slot, (Object)container.getItem(start + slot));
        }
        TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)registries);
        ContainerHelper.saveAllItems((ValueOutput)output, (NonNullList)items, (boolean)true);
        return output.buildResult();
    }

    private static final class TrackingContainer
    extends SimpleContainer {
        private Runnable listener = () -> {};

        private TrackingContainer(int size) {
            super(size);
        }

        private void setListener(Runnable listener) {
            this.listener = listener != null ? listener : () -> {};
        }

        public void setChanged() {
            super.setChanged();
            this.listener.run();
        }
    }

    private static final class SlotRangeContainer
    implements Container {
        private final TrackingContainer backing;
        private final int offset;
        private final int size;

        private SlotRangeContainer(TrackingContainer backing, int offset, int size) {
            this.backing = backing;
            this.offset = offset;
            this.size = size;
        }

        public int getContainerSize() {
            return this.size;
        }

        public boolean isEmpty() {
            for (int slot = 0; slot < this.size; ++slot) {
                if (this.backing.getItem(this.offset + slot).isEmpty()) continue;
                return false;
            }
            return true;
        }

        public ItemStack getItem(int slot) {
            return this.backing.getItem(this.offset + slot);
        }

        public ItemStack removeItem(int slot, int amount) {
            ItemStack result = this.backing.removeItem(this.offset + slot, amount);
            this.setChanged();
            return result;
        }

        public ItemStack removeItemNoUpdate(int slot) {
            ItemStack result = this.backing.removeItemNoUpdate(this.offset + slot);
            this.setChanged();
            return result;
        }

        public void setItem(int slot, ItemStack stack) {
            this.backing.setItem(this.offset + slot, stack);
        }

        public void setChanged() {
            this.backing.setChanged();
        }

        public boolean stillValid(Player player) {
            return this.backing.stillValid(player);
        }

        public boolean canPlaceItem(int slot, ItemStack stack) {
            return this.backing.canPlaceItem(this.offset + slot, stack);
        }

        public int getMaxStackSize() {
            return this.backing.getMaxStackSize();
        }

        public void clearContent() {
            for (int slot = 0; slot < this.size; ++slot) {
                this.backing.setItem(this.offset + slot, ItemStack.EMPTY);
            }
        }
    }
}

