/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.data;

import com.foundryx.storage.FoundryxDataStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class HomeData {
    private final Map<String, FoundryxDataStorage.LocationSnapshot> homes = new HashMap<String, FoundryxDataStorage.LocationSnapshot>();

    public HomeData() {
    }

    public HomeData(Map<String, FoundryxDataStorage.LocationSnapshot> initialHomes) {
        if (initialHomes == null) {
            return;
        }
        initialHomes.forEach((name, snapshot) -> {
            if (name != null && snapshot != null) {
                this.homes.put(HomeData.normalise(name), (FoundryxDataStorage.LocationSnapshot)snapshot);
            }
        });
    }

    public void set(String name, FoundryxDataStorage.LocationSnapshot location) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(location, "location");
        this.homes.put(HomeData.normalise(name), location);
    }

    public Optional<FoundryxDataStorage.LocationSnapshot> get(String name) {
        Objects.requireNonNull(name, "name");
        return Optional.ofNullable(this.homes.get(HomeData.normalise(name)));
    }

    public boolean remove(String name) {
        Objects.requireNonNull(name, "name");
        return this.homes.remove(HomeData.normalise(name)) != null;
    }

    public Collection<String> names() {
        if (this.homes.isEmpty()) {
            return List.of();
        }
        ArrayList<String> names = new ArrayList<String>(this.homes.keySet());
        names.sort(String::compareToIgnoreCase);
        return names;
    }

    public Map<String, FoundryxDataStorage.LocationSnapshot> asMap() {
        return Map.copyOf(this.homes);
    }

    public boolean isEmpty() {
        return this.homes.isEmpty();
    }

    private static String normalise(String name) {
        return name.toLowerCase(Locale.ROOT);
    }
}

