/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public final class KitData {
    private final String name;
    private final List<ItemStack> items;
    private final long cooldownSeconds;

    public KitData(String name, List<ItemStack> items, long cooldownSeconds) {
        this.name = Objects.requireNonNull(name, "name");
        ArrayList<ItemStack> copies = new ArrayList<ItemStack>();
        if (items != null) {
            for (ItemStack stack : items) {
                if (stack == null || stack.isEmpty()) continue;
                copies.add(stack.copy());
            }
        }
        this.items = Collections.unmodifiableList(copies);
        this.cooldownSeconds = Math.max(0L, cooldownSeconds);
    }

    public String name() {
        return this.name;
    }

    public long cooldownSeconds() {
        return this.cooldownSeconds;
    }

    public List<ItemStack> items() {
        ArrayList<ItemStack> copies = new ArrayList<ItemStack>(this.items.size());
        for (ItemStack stack : this.items) {
            copies.add(stack.copy());
        }
        return copies;
    }

    public CompoundTag save(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        tag.putString("Name", this.name);
        tag.putLong("Cooldown", this.cooldownSeconds);
        int size = this.items.size();
        tag.putInt("Size", size);
        NonNullList list = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        for (int slot = 0; slot < size; ++slot) {
            list.set(slot, (Object)this.items.get(slot));
        }
        TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)registries);
        ContainerHelper.saveAllItems((ValueOutput)output, (NonNullList)list, (boolean)true);
        tag.put("Items", (Tag)output.buildResult());
        return tag;
    }

    public static KitData load(CompoundTag tag, HolderLookup.Provider registries) {
        if (tag == null) {
            return null;
        }
        String name = tag.getString("Name").orElse(null);
        if (name == null || name.isBlank()) {
            return null;
        }
        long cooldown = tag.getLong("Cooldown").orElse(0L);
        int size = Math.max(0, tag.getInt("Size").orElse(0));
        NonNullList list = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        tag.getCompound("Items").ifPresent(compound -> {
            ValueInput input = TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)registries, (CompoundTag)compound);
            ContainerHelper.loadAllItems((ValueInput)input, (NonNullList)list);
        });
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(list.size());
        for (ItemStack stack : list) {
            if (stack.isEmpty()) continue;
            items.add(stack);
        }
        return new KitData(name, items, cooldown);
    }
}

