/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.data;

import com.foundryx.storage.FoundryxDataStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class WarpData {
    private final Map<String, FoundryxDataStorage.LocationSnapshot> warps = new HashMap<String, FoundryxDataStorage.LocationSnapshot>();

    public WarpData() {
    }

    public WarpData(Map<String, FoundryxDataStorage.LocationSnapshot> initialWarps) {
        if (initialWarps == null) {
            return;
        }
        initialWarps.forEach((name, snapshot) -> {
            if (name != null && snapshot != null) {
                this.warps.put(WarpData.normalise(name), (FoundryxDataStorage.LocationSnapshot)snapshot);
            }
        });
    }

    public void set(String name, FoundryxDataStorage.LocationSnapshot location) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(location, "location");
        this.warps.put(WarpData.normalise(name), location);
    }

    public Optional<FoundryxDataStorage.LocationSnapshot> get(String name) {
        Objects.requireNonNull(name, "name");
        return Optional.ofNullable(this.warps.get(WarpData.normalise(name)));
    }

    public boolean remove(String name) {
        Objects.requireNonNull(name, "name");
        return this.warps.remove(WarpData.normalise(name)) != null;
    }

    public Collection<String> names() {
        if (this.warps.isEmpty()) {
            return List.of();
        }
        ArrayList<String> names = new ArrayList<String>(this.warps.keySet());
        names.sort(String::compareToIgnoreCase);
        return names;
    }

    public Map<String, FoundryxDataStorage.LocationSnapshot> asMap() {
        return Map.copyOf(this.warps);
    }

    public boolean isEmpty() {
        return this.warps.isEmpty();
    }

    private static String normalise(String name) {
        return name.toLowerCase(Locale.ROOT);
    }
}

