/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.event;

import com.foundryx.command.admin.JailHooks;
import com.foundryx.command.admin.JailRestrictions;
import com.foundryx.managers.AfkManager;
import com.foundryx.managers.TabManager;
import com.foundryx.managers.VanishManager;
import com.foundryx.storage.FoundryxDataStorage;
import com.foundryx.teleport.TeleportDelayManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public final class FoundryxCommonEvents {
    private FoundryxCommonEvents() {
    }

    public static void onServerTick(MinecraftServer server) {
        AfkManager.handleServerTick(server);
        FoundryxDataStorage.get(server).tick();
        TeleportDelayManager.get(server).tick(server);
        TabManager.handleServerTick(server);
    }

    public static void onPlayerJoin(ServerPlayer player) {
        MinecraftServer server = player.level().getServer();
        if (server != null) {
            FoundryxDataStorage storage = FoundryxDataStorage.get(server);
            storage.updateWhoisSnapshot(player);
            storage.recordLogin(player);
        }
        JailHooks.handlePlayerJoin(player);
        AfkManager.handlePlayerJoin(player);
        VanishManager.handlePlayerJoin(player);
        TabManager.handlePlayerJoin(player);
    }

    public static void onPlayerQuit(ServerPlayer player) {
        MinecraftServer server = player.level().getServer();
        if (server != null) {
            FoundryxDataStorage storage = FoundryxDataStorage.get(server);
            storage.updateWhoisSnapshot(player);
            storage.recordLogout(player);
            TeleportDelayManager.get(server).handlePlayerQuit(player);
        }
        VanishManager.handlePlayerQuit(player);
        TabManager.handlePlayerQuit(player);
        AfkManager.handlePlayerQuit(player);
        JailRestrictions.clearNotice(player);
    }

    public static void onPlayerTick(ServerPlayer player) {
        MinecraftServer server = player.level().getServer();
        if (server != null) {
            TeleportDelayManager.get(server).handlePlayerTick(player);
        }
        AfkManager.handlePlayerTick(player);
        VanishManager.handlePlayerTick(player);
    }

    public static void onPlayerDamaged(ServerPlayer player) {
        AfkManager.handleDamage(player);
        MinecraftServer server = player.level().getServer();
        if (server != null) {
            TeleportDelayManager.get(server).handlePlayerDamage(player);
        }
    }

    public static void onPlayerDeath(ServerPlayer player, String cause) {
        MinecraftServer server = player.level().getServer();
        if (server == null) {
            return;
        }
        FoundryxDataStorage storage = FoundryxDataStorage.get(server);
        storage.recordDeath(player, cause);
        storage.rememberBack(player);
    }
}

