/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.localization;

import com.foundryx.Constants;
import com.foundryx.chat.ChatFormatter;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringUtil;

public final class Localization {
    private static final String LANGUAGE_PATH_FORMAT = "assets/%s/lang/%s.json";
    private static final Map<String, Map<String, String>> CACHE = new ConcurrentHashMap<String, Map<String, String>>();
    private static Map<String, String> translations = Map.of();
    private static Map<String, String> fallbackTranslations = Map.of();
    private static String activeLanguage = "en_us";

    private Localization() {
    }

    public static void load(String languageId) {
        String normalized;
        activeLanguage = normalized = Localization.normalize(languageId);
        fallbackTranslations = Localization.loadLanguage("en_us");
        if (normalized.equals("en_us")) {
            translations = fallbackTranslations;
            Constants.LOG.debug("Localization initialised with language {}", (Object)normalized);
            return;
        }
        Map<String, String> selected = Localization.loadLanguage(normalized);
        if (selected.isEmpty()) {
            Constants.LOG.warn("Could not load translations for {}, falling back to en_us", (Object)normalized);
            translations = fallbackTranslations;
        } else {
            HashMap<String, String> merged = new HashMap<String, String>(fallbackTranslations);
            merged.putAll(selected);
            translations = merged;
            Constants.LOG.debug("Localization initialised with language {}", (Object)normalized);
        }
    }

    private static Map<String, String> loadLanguage(String language) {
        return CACHE.computeIfAbsent(language, Localization::readLanguageFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> readLanguageFile(String language) {
        String path = String.format(Locale.ROOT, LANGUAGE_PATH_FORMAT, "foundryx", language);
        try (InputStream stream = Localization.class.getClassLoader().getResourceAsStream(path);){
            if (stream == null) {
                Map<String, String> map2 = Map.of();
                return map2;
            }
            HashMap values = new HashMap();
            try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                GsonHelper.parse((Reader)reader).getAsJsonObject().entrySet().forEach(entry -> values.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString()));
            }
            Map<String, String> map = Map.copyOf(values);
            return map;
        }
        catch (ClassCastException | IllegalStateException exception) {
            Constants.LOG.error("Failed to parse translation file {}", (Object)path, (Object)exception);
            return Map.of();
        }
        catch (IOException exception) {
            Constants.LOG.error("Failed to read translation file {}", (Object)path, (Object)exception);
            return Map.of();
        }
    }

    private static String normalize(String languageId) {
        if (StringUtil.isNullOrEmpty((String)languageId)) {
            return "en_us";
        }
        return languageId.toLowerCase(Locale.ROOT);
    }

    public static MutableComponent formatted(String key) {
        return Localization.formatted(key, new Object[0]);
    }

    public static MutableComponent formatted(String key, Object ... arguments) {
        String value = translations.get(key);
        if (value == null) {
            value = fallbackTranslations.get(key);
        }
        if (value == null) {
            return Component.translatable((String)key, (Object[])arguments).withStyle(ChatFormatting.GRAY);
        }
        return Localization.buildFormattedComponent(value, arguments);
    }

    public static String raw(String key) {
        String value = translations.get(key);
        if (value != null) {
            return value;
        }
        return fallbackTranslations.get(key);
    }

    public static String activeLanguage() {
        return activeLanguage;
    }

    private static MutableComponent buildFormattedComponent(String template, Object[] arguments) {
        MutableComponent result = Component.empty();
        StringBuilder buffer = new StringBuilder();
        int argumentIndex = 0;
        for (int i = 0; i < template.length(); ++i) {
            char character = template.charAt(i);
            if (character != '%') {
                buffer.append(character);
                continue;
            }
            if (i + 1 >= template.length()) {
                buffer.append(character);
                continue;
            }
            char next = template.charAt(i + 1);
            if (next == '%') {
                buffer.append('%');
                ++i;
                continue;
            }
            if (next != 's') {
                buffer.append(character);
                continue;
            }
            Localization.appendBuffer(result, buffer);
            ++i;
            if (argumentIndex >= arguments.length) continue;
            result.append((Component)Localization.toComponent(arguments[argumentIndex++]));
        }
        Localization.appendBuffer(result, buffer);
        return result;
    }

    private static void appendBuffer(MutableComponent result, StringBuilder buffer) {
        if (buffer.length() == 0) {
            return;
        }
        Component component = ChatFormatter.legacyToComponent(buffer.toString());
        buffer.setLength(0);
        if (component == null) {
            return;
        }
        if (component instanceof MutableComponent) {
            MutableComponent mutable = (MutableComponent)component;
            result.append((Component)mutable);
        } else {
            result.append((Component)component.copy());
        }
    }

    private static MutableComponent toComponent(Object value) {
        if (value instanceof MutableComponent) {
            MutableComponent mutable = (MutableComponent)value;
            return mutable.copy();
        }
        if (value instanceof Component) {
            Component component = (Component)value;
            return component.copy();
        }
        if (value == null) {
            return Component.empty();
        }
        return Component.literal((String)String.valueOf(value));
    }
}

