/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.managers;

import com.foundryx.config.ModConfig;
import com.foundryx.localization.Localization;
import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.FoundryxPermissions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;

public final class AfkManager {
    private static final double MOVEMENT_THRESHOLD_SQUARED = 1.5;
    private static final Set<UUID> MANUAL_AFK = new HashSet<UUID>();
    private static final Set<UUID> AFK_PLAYERS = new HashSet<UUID>();
    private static final Map<UUID, Integer> INACTIVITY_TICKS = new HashMap<UUID, Integer>();
    private static final Map<UUID, Integer> AFK_TICKS = new HashMap<UUID, Integer>();
    private static final Map<UUID, Vec3> LAST_POSITIONS = new HashMap<UUID, Vec3>();
    private static final Map<UUID, Long> LAST_MANUAL_TOGGLE = new HashMap<UUID, Long>();
    private static final Set<UUID> KICK_NOTICE_SENT = new HashSet<UUID>();

    private AfkManager() {
    }

    public static boolean isAfk(ServerPlayer player) {
        return AFK_PLAYERS.contains(player.getUUID()) || MANUAL_AFK.contains(player.getUUID());
    }

    public static boolean isManualAfk(ServerPlayer player) {
        return MANUAL_AFK.contains(player.getUUID());
    }

    public static void toggleManual(ServerPlayer player) {
        AfkManager.setManualAfk(player, !AfkManager.isManualAfk(player));
    }

    public static void setManualAfk(ServerPlayer player, boolean enable) {
        UUID uuid = player.getUUID();
        if (enable) {
            if (MANUAL_AFK.contains(uuid) && AFK_PLAYERS.contains(uuid)) {
                return;
            }
            MANUAL_AFK.add(uuid);
            AFK_PLAYERS.add(uuid);
            AFK_TICKS.put(uuid, 0);
            INACTIVITY_TICKS.put(uuid, 0);
            LAST_MANUAL_TOGGLE.put(uuid, System.currentTimeMillis());
            KICK_NOTICE_SENT.remove(uuid);
            player.sendSystemMessage((Component)Localization.formatted("commands.foundryx.afk.enabled"));
            AfkManager.broadcast(player, "commands.foundryx.afk.broadcast_on");
            return;
        }
        boolean wasManual = MANUAL_AFK.contains(uuid);
        boolean wasAfk = AFK_PLAYERS.contains(uuid);
        String message = wasManual || wasAfk ? "commands.foundryx.afk.disabled" : null;
        AfkManager.clearAfk(player, wasManual, message);
    }

    public static void handlePlayerJoin(ServerPlayer player) {
        UUID uuid = player.getUUID();
        AfkManager.resetState(uuid);
        LAST_POSITIONS.put(uuid, player.position());
    }

    public static void handlePlayerQuit(ServerPlayer player) {
        UUID uuid = player.getUUID();
        AfkManager.resetState(uuid);
        LAST_POSITIONS.remove(uuid);
    }

    public static void handlePlayerTick(ServerPlayer player) {
        UUID uuid = player.getUUID();
        Vec3 current = player.position();
        Vec3 previous = LAST_POSITIONS.get(uuid);
        if (previous == null) {
            LAST_POSITIONS.put(uuid, current);
            return;
        }
        if (previous.distanceToSqr(current) > 1.5) {
            LAST_POSITIONS.put(uuid, current);
            AfkManager.recordActivity(player);
        }
    }

    public static void handleChat(ServerPlayer player) {
        AfkManager.recordActivity(player);
    }

    public static void handleDamage(ServerPlayer player) {
        AfkManager.recordActivity(player);
    }

    public static void handleServerTick(MinecraftServer server) {
        int timeoutTicks = Math.max(ModConfig.get().afk().timeoutMinutes(), 0) * 60 * 20;
        int kickTicks = Math.max(ModConfig.get().afk().kickAfterMinutes(), 0) * 60 * 20;
        boolean kickEnabled = ModConfig.get().afk().kickEnabled();
        ArrayList<ServerPlayer> playersToKick = new ArrayList<ServerPlayer>();
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            UUID uuid = player.getUUID();
            LAST_POSITIONS.putIfAbsent(uuid, player.position());
            int inactivity = INACTIVITY_TICKS.getOrDefault(uuid, 0) + 1;
            INACTIVITY_TICKS.put(uuid, inactivity);
            if (!MANUAL_AFK.contains(uuid) && !AFK_PLAYERS.contains(uuid) && timeoutTicks > 0 && inactivity >= timeoutTicks) {
                AfkManager.enableAutoAfk(player);
            }
            if (!AFK_PLAYERS.contains(uuid) && !MANUAL_AFK.contains(uuid)) continue;
            int afkTime = AFK_TICKS.getOrDefault(uuid, 0) + 1;
            AFK_TICKS.put(uuid, afkTime);
            if (kickEnabled && kickTicks > 0 && afkTime >= kickTicks) {
                if (!FoundryxPermissions.check(player, FoundryxPermission.AFK_KICK_EXEMPT)) {
                    playersToKick.add(player);
                    continue;
                }
                if (!KICK_NOTICE_SENT.add(uuid)) continue;
                player.sendSystemMessage((Component)Localization.formatted("commands.foundryx.afk.exempt_notice"));
                continue;
            }
            KICK_NOTICE_SENT.remove(uuid);
        }
        if (!playersToKick.isEmpty()) {
            MutableComponent kickMessage = Localization.formatted("commands.foundryx.afk.kicked");
            for (ServerPlayer player : playersToKick) {
                player.connection.disconnect((Component)kickMessage.copy());
                AfkManager.resetState(player.getUUID());
            }
        }
    }

    private static void enableAutoAfk(ServerPlayer player) {
        UUID uuid = player.getUUID();
        if (!AFK_PLAYERS.add(uuid)) {
            return;
        }
        AFK_TICKS.put(uuid, 0);
        INACTIVITY_TICKS.put(uuid, 0);
        player.sendSystemMessage((Component)Localization.formatted("commands.foundryx.afk.auto_enabled"));
        AfkManager.broadcast(player, "commands.foundryx.afk.broadcast_on");
    }

    private static void recordActivity(ServerPlayer player) {
        boolean isAfk;
        UUID uuid = player.getUUID();
        INACTIVITY_TICKS.put(uuid, 0);
        KICK_NOTICE_SENT.remove(uuid);
        boolean isManual = MANUAL_AFK.contains(uuid);
        boolean bl = isAfk = AFK_PLAYERS.contains(uuid) || isManual;
        if (!isAfk) {
            return;
        }
        if (isManual) {
            long lastToggle = LAST_MANUAL_TOGGLE.getOrDefault(uuid, 0L);
            if (System.currentTimeMillis() - lastToggle < 1000L) {
                return;
            }
        }
        AfkManager.clearAfk(player, isManual, isManual ? "commands.foundryx.afk.disabled" : "commands.foundryx.afk.auto_disabled");
    }

    private static void clearAfk(ServerPlayer player, boolean wasManual, String messageKey) {
        boolean hadAfkState;
        UUID uuid = player.getUUID();
        boolean removedAfk = AFK_PLAYERS.remove(uuid);
        boolean removedManual = MANUAL_AFK.remove(uuid);
        if (wasManual) {
            removedManual = true;
        }
        LAST_MANUAL_TOGGLE.remove(uuid);
        AFK_TICKS.remove(uuid);
        INACTIVITY_TICKS.put(uuid, 0);
        KICK_NOTICE_SENT.remove(uuid);
        boolean bl = hadAfkState = removedAfk || removedManual;
        if (!hadAfkState) {
            return;
        }
        if (messageKey != null) {
            player.sendSystemMessage((Component)Localization.formatted(messageKey));
        }
        AfkManager.broadcast(player, "commands.foundryx.afk.broadcast_off");
    }

    private static void broadcast(ServerPlayer player, String key) {
        MinecraftServer server = player.level().getServer();
        if (server == null) {
            return;
        }
        MutableComponent component = Localization.formatted(key, player.getDisplayName());
        for (ServerPlayer viewer : server.getPlayerList().getPlayers()) {
            viewer.sendSystemMessage((Component)component.copy());
        }
        server.sendSystemMessage((Component)component.copy());
    }

    private static void resetState(UUID uuid) {
        MANUAL_AFK.remove(uuid);
        AFK_PLAYERS.remove(uuid);
        AFK_TICKS.remove(uuid);
        INACTIVITY_TICKS.remove(uuid);
        LAST_MANUAL_TOGGLE.remove(uuid);
        KICK_NOTICE_SENT.remove(uuid);
    }
}

