/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.managers;

import com.foundryx.Constants;
import com.foundryx.config.ModConfig;
import com.foundryx.data.BackData;
import com.foundryx.storage.FoundryxDataStorage;
import com.foundryx.storage.database.DatabaseContext;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public final class BackDataManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Path directory;
    private final Map<UUID, BackData> cache = new HashMap<UUID, BackData>();
    private final boolean useDatabase;
    private final DatabaseContext database;

    public BackDataManager(Path directory) {
        this(directory, null);
    }

    public BackDataManager(Path directory, DatabaseContext database) {
        this.directory = directory;
        this.database = database;
        boolean databaseEnabled = ModConfig.get().storage().useDatabase();
        this.useDatabase = databaseEnabled && database != null && database.isAvailable();
    }

    public void rememberBack(UUID player, FoundryxDataStorage.LocationSnapshot snapshot) {
        if (player == null || snapshot == null) {
            return;
        }
        if (this.useDatabase) {
            this.rememberBackDatabase(player, snapshot);
            return;
        }
        BackData data = this.load(player);
        data.update(snapshot, System.currentTimeMillis());
        this.save(player, data);
    }

    public Optional<FoundryxDataStorage.TeleportTarget> consumeBack(UUID player) {
        if (player == null) {
            return Optional.empty();
        }
        if (this.useDatabase) {
            return this.consumeBackDatabase(player);
        }
        BackData data = this.load(player);
        Optional<FoundryxDataStorage.TeleportTarget> result = data.location().flatMap(FoundryxDataStorage.LocationSnapshot::toTeleportTarget);
        if (data.clear()) {
            this.save(player, data);
        }
        return result;
    }

    private BackData load(UUID player) {
        if (this.useDatabase) {
            return new BackData();
        }
        return this.cache.computeIfAbsent(player, this::readData);
    }

    private BackData readData(UUID player) {
        Path file = this.filePath(player);
        BackData data = new BackData();
        if (!Files.exists(file, new LinkOption[0])) {
            return data;
        }
        try (BufferedReader reader = Files.newBufferedReader(file);){
            PersistedBackData persisted = (PersistedBackData)GSON.fromJson((Reader)reader, PersistedBackData.class);
            if (persisted != null && persisted.location() != null) {
                long timestamp = persisted.recordedAt() == null ? System.currentTimeMillis() : persisted.recordedAt();
                data.update(persisted.location(), timestamp);
            }
        }
        catch (IOException exception) {
            Constants.LOG.error("Failed to read back data for {}", (Object)player, (Object)exception);
        }
        return data;
    }

    private void save(UUID player, BackData data) {
        if (this.useDatabase) {
            return;
        }
        Path file = this.filePath(player);
        try {
            if (data.location().isEmpty()) {
                this.cache.remove(player);
                Files.deleteIfExists(file);
                return;
            }
            Files.createDirectories(this.directory, new FileAttribute[0]);
            PersistedBackData persisted = new PersistedBackData(data.location().orElse(null), data.recordedAt().orElse(null));
            try (BufferedWriter writer = Files.newBufferedWriter(file, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
                GSON.toJson((Object)persisted, (Appendable)writer);
            }
        }
        catch (IOException exception) {
            Constants.LOG.error("Failed to write back data for {}", (Object)player, (Object)exception);
        }
    }

    private Path filePath(UUID player) {
        return this.directory.resolve(player.toString() + ".json");
    }

    private void rememberBackDatabase(UUID player, FoundryxDataStorage.LocationSnapshot snapshot) {
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            long timestamp = System.currentTimeMillis();
            try (PreparedStatement update = connection.prepareStatement("UPDATE foundryx_back_data SET dimension=?, x=?, y=?, z=?, yaw=?, pitch=?, recorded_at=? WHERE player_uuid=?");){
                this.bindLocation(update, snapshot, timestamp);
                update.setString(8, player.toString());
                int updated = update.executeUpdate();
                if (updated == 0) {
                    try (PreparedStatement insert = connection.prepareStatement("INSERT INTO foundryx_back_data (dimension, x, y, z, yaw, pitch, recorded_at, player_uuid) VALUES (?,?,?,?,?,?,?,?)");){
                        this.bindLocation(insert, snapshot, timestamp);
                        insert.setString(8, player.toString());
                        insert.executeUpdate();
                    }
                }
                connection.commit();
            }
            catch (SQLException exception) {
                connection.rollback();
                throw exception;
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException exception) {
            Constants.LOG.error("Failed to persist back data for {}", (Object)player, (Object)exception);
        }
    }

    private Optional<FoundryxDataStorage.TeleportTarget> consumeBackDatabase(UUID player) {
        FoundryxDataStorage.LocationSnapshot snapshot;
        block29: {
            snapshot = null;
            try (Connection connection = this.database.getConnection();){
                try (PreparedStatement select = connection.prepareStatement("SELECT dimension, x, y, z, yaw, pitch FROM foundryx_back_data WHERE player_uuid=?");){
                    select.setString(1, player.toString());
                    try (ResultSet resultSet = select.executeQuery();){
                        if (resultSet.next()) {
                            snapshot = this.mapSnapshot(resultSet);
                        }
                    }
                }
                if (snapshot == null) break block29;
                try (PreparedStatement delete = connection.prepareStatement("DELETE FROM foundryx_back_data WHERE player_uuid=?");){
                    delete.setString(1, player.toString());
                    delete.executeUpdate();
                }
            }
            catch (SQLException exception) {
                Constants.LOG.error("Failed to consume back data for {}", (Object)player, (Object)exception);
            }
        }
        if (snapshot == null) {
            return Optional.empty();
        }
        return snapshot.toTeleportTarget();
    }

    private void bindLocation(PreparedStatement statement, FoundryxDataStorage.LocationSnapshot snapshot, long timestamp) throws SQLException {
        statement.setString(1, snapshot.dimension());
        statement.setDouble(2, snapshot.x());
        statement.setDouble(3, snapshot.y());
        statement.setDouble(4, snapshot.z());
        statement.setFloat(5, snapshot.yaw());
        statement.setFloat(6, snapshot.pitch());
        statement.setLong(7, timestamp);
    }

    private FoundryxDataStorage.LocationSnapshot mapSnapshot(ResultSet resultSet) throws SQLException {
        String dimension = resultSet.getString("dimension");
        double x = resultSet.getDouble("x");
        double y = resultSet.getDouble("y");
        double z = resultSet.getDouble("z");
        float yaw = resultSet.getFloat("yaw");
        float pitch = resultSet.getFloat("pitch");
        return new FoundryxDataStorage.LocationSnapshot(dimension, x, y, z, yaw, pitch);
    }

    public void flush() {
    }

    private record PersistedBackData(FoundryxDataStorage.LocationSnapshot location, Long recordedAt) {
    }
}

