/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.managers;

import com.foundryx.Constants;
import com.foundryx.config.ModConfig;
import com.foundryx.data.DeathData;
import com.foundryx.storage.FoundryxDataStorage;
import com.foundryx.storage.database.DatabaseContext;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public final class DeathDataManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Path directory;
    private final Map<UUID, DeathData> cache = new HashMap<UUID, DeathData>();
    private final boolean useDatabase;
    private final DatabaseContext database;

    public DeathDataManager(Path directory) {
        this(directory, null);
    }

    public DeathDataManager(Path directory, DatabaseContext database) {
        this.directory = directory;
        this.database = database;
        boolean databaseEnabled = ModConfig.get().storage().useDatabase();
        this.useDatabase = databaseEnabled && database != null && database.isAvailable();
    }

    public void recordDeath(UUID player, FoundryxDataStorage.LocationSnapshot snapshot, String cause, long timestamp) {
        if (player == null || snapshot == null) {
            return;
        }
        if (this.useDatabase) {
            this.recordDeathDatabase(player, snapshot, cause, timestamp);
            return;
        }
        DeathData data = this.load(player);
        data.record(snapshot, timestamp, cause);
        this.save(player, data);
    }

    public Optional<DeathData> get(UUID player) {
        if (player == null) {
            return Optional.empty();
        }
        if (this.useDatabase) {
            return this.loadFromDatabase(player);
        }
        DeathData data = this.load(player);
        if (data.location().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(data);
    }

    public Optional<FoundryxDataStorage.TeleportTarget> getTeleportTarget(UUID player) {
        return this.get(player).flatMap(DeathData::location).flatMap(FoundryxDataStorage.LocationSnapshot::toTeleportTarget);
    }

    private DeathData load(UUID player) {
        if (this.useDatabase) {
            return new DeathData();
        }
        return this.cache.computeIfAbsent(player, this::readData);
    }

    private DeathData readData(UUID player) {
        Path file = this.filePath(player);
        DeathData data = new DeathData();
        if (!Files.exists(file, new LinkOption[0])) {
            return data;
        }
        try (BufferedReader reader = Files.newBufferedReader(file);){
            PersistedDeathData persisted = (PersistedDeathData)GSON.fromJson((Reader)reader, PersistedDeathData.class);
            if (persisted != null && persisted.location() != null) {
                long timestamp = persisted.deathTime() == null ? System.currentTimeMillis() : persisted.deathTime();
                data.record(persisted.location(), timestamp, persisted.cause());
            }
        }
        catch (IOException exception) {
            Constants.LOG.error("Failed to read death data for {}", (Object)player, (Object)exception);
        }
        return data;
    }

    private void save(UUID player, DeathData data) {
        if (this.useDatabase) {
            return;
        }
        Path file = this.filePath(player);
        try {
            if (data.location().isEmpty()) {
                this.cache.remove(player);
                Files.deleteIfExists(file);
                return;
            }
            Files.createDirectories(this.directory, new FileAttribute[0]);
            PersistedDeathData persisted = new PersistedDeathData(data.location().orElse(null), data.deathTime().orElse(null), data.cause().orElse(null));
            try (BufferedWriter writer = Files.newBufferedWriter(file, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
                GSON.toJson((Object)persisted, (Appendable)writer);
            }
        }
        catch (IOException exception) {
            Constants.LOG.error("Failed to write death data for {}", (Object)player, (Object)exception);
        }
    }

    private Path filePath(UUID player) {
        return this.directory.resolve(player.toString() + ".json");
    }

    private void recordDeathDatabase(UUID player, FoundryxDataStorage.LocationSnapshot snapshot, String cause, long timestamp) {
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            try (PreparedStatement update = connection.prepareStatement("UPDATE foundryx_death_data SET dimension=?, x=?, y=?, z=?, yaw=?, pitch=?, cause=?, death_time=? WHERE player_uuid=?");){
                this.bindSnapshot(update, snapshot);
                if (cause == null) {
                    update.setNull(7, 12);
                } else {
                    update.setString(7, cause);
                }
                update.setLong(8, timestamp);
                update.setString(9, player.toString());
                int updated = update.executeUpdate();
                if (updated == 0) {
                    try (PreparedStatement insert = connection.prepareStatement("INSERT INTO foundryx_death_data (dimension, x, y, z, yaw, pitch, cause, death_time, player_uuid) VALUES (?,?,?,?,?,?,?,?,?)");){
                        this.bindSnapshot(insert, snapshot);
                        if (cause == null) {
                            insert.setNull(7, 12);
                        } else {
                            insert.setString(7, cause);
                        }
                        insert.setLong(8, timestamp);
                        insert.setString(9, player.toString());
                        insert.executeUpdate();
                    }
                }
                connection.commit();
            }
            catch (SQLException exception) {
                connection.rollback();
                throw exception;
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException exception) {
            Constants.LOG.error("Failed to record death data for {}", (Object)player, (Object)exception);
        }
    }

    /*
     * Exception decompiling
     */
    private Optional<DeathData> loadFromDatabase(UUID player) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void bindSnapshot(PreparedStatement statement, FoundryxDataStorage.LocationSnapshot snapshot) throws SQLException {
        statement.setString(1, snapshot.dimension());
        statement.setDouble(2, snapshot.x());
        statement.setDouble(3, snapshot.y());
        statement.setDouble(4, snapshot.z());
        statement.setFloat(5, snapshot.yaw());
        statement.setFloat(6, snapshot.pitch());
    }

    private FoundryxDataStorage.LocationSnapshot mapSnapshot(ResultSet resultSet) throws SQLException {
        String dimension = resultSet.getString("dimension");
        double x = resultSet.getDouble("x");
        double y = resultSet.getDouble("y");
        double z = resultSet.getDouble("z");
        float yaw = resultSet.getFloat("yaw");
        float pitch = resultSet.getFloat("pitch");
        return new FoundryxDataStorage.LocationSnapshot(dimension, x, y, z, yaw, pitch);
    }

    public void flush() {
    }

    private record PersistedDeathData(FoundryxDataStorage.LocationSnapshot location, Long deathTime, String cause) {
    }
}

