/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.managers;

import com.foundryx.Constants;
import com.foundryx.data.EnderChestData;
import com.foundryx.storage.FoundryxDataStorage;
import com.foundryx.storage.database.DatabaseContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;

public final class EnderChestManager {
    private static final Map<MinecraftServer, EnderChestManager> INSTANCES = new WeakHashMap<MinecraftServer, EnderChestManager>();
    private final MinecraftServer server;
    private final Path directory;
    private final Map<UUID, EnderChestData> cache = new HashMap<UUID, EnderChestData>();
    private final boolean useDatabase;
    private final DatabaseContext database;

    private EnderChestManager(MinecraftServer server) {
        this.server = server;
        Path root = server.getWorldPath(LevelResource.ROOT).resolve("foundryx");
        this.directory = root.resolve("enderchests");
        FoundryxDataStorage storage = FoundryxDataStorage.get(server);
        this.database = storage.getDatabaseContext();
        this.useDatabase = this.database != null && this.database.isAvailable();
    }

    public static EnderChestData get(ServerPlayer player) {
        EnderChestManager manager = EnderChestManager.get(player.level().getServer());
        return manager.get(player.getUUID(), player.getScoreboardName());
    }

    public static EnderChestData getByName(MinecraftServer server, String username) {
        EnderChestManager manager = EnderChestManager.get(server);
        return manager.getByUsername(username);
    }

    public static void save(ServerPlayer player, EnderChestData data) {
        EnderChestManager manager = EnderChestManager.get(player.level().getServer());
        manager.save(player.getUUID(), data);
    }

    private static EnderChestManager get(MinecraftServer server) {
        return INSTANCES.computeIfAbsent(server, EnderChestManager::new);
    }

    private EnderChestData get(UUID playerId, String currentName) {
        EnderChestData data = this.cache.computeIfAbsent(playerId, this::loadData);
        if (currentName != null) {
            data.updateLastKnownUsername(currentName);
        }
        data.setChangeListener(() -> this.save(playerId, data));
        return data;
    }

    private EnderChestData getByUsername(String username) {
        EnderChestData enderChestData;
        block12: {
            if (username == null || username.isBlank()) {
                return null;
            }
            String normalised = username.toLowerCase(Locale.ROOT);
            for (Map.Entry<UUID, EnderChestData> entry : this.cache.entrySet()) {
                String cachedName = entry.getValue().getLastKnownUsername();
                if (cachedName == null || !cachedName.toLowerCase(Locale.ROOT).equals(normalised)) continue;
                return entry.getValue();
            }
            if (this.useDatabase) {
                return this.loadFromDatabaseByName(normalised);
            }
            if (!Files.exists(this.directory, new LinkOption[0])) {
                return null;
            }
            Stream<Path> files = Files.list(this.directory);
            try {
                enderChestData = files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(this::loadFromFile).filter(Objects::nonNull).filter(data -> {
                    String stored = data.getLastKnownUsername();
                    return stored != null && stored.toLowerCase(Locale.ROOT).equals(normalised);
                }).findFirst().orElse(null);
                if (files == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    Constants.LOG.error("Failed to enumerate stored ender chests", (Throwable)exception);
                    return null;
                }
            }
            files.close();
        }
        return enderChestData;
    }

    private EnderChestData loadData(UUID playerId) {
        if (this.useDatabase) {
            return this.readDataFromDatabase(playerId);
        }
        return this.readDataFromFile(playerId);
    }

    private EnderChestData loadFromFile(Path path) {
        UUID id = EnderChestManager.parseFileId(path.getFileName().toString());
        if (id == null) {
            return null;
        }
        EnderChestData existing = this.cache.get(id);
        if (existing != null) {
            return existing;
        }
        EnderChestData data = this.readDataFromFile(id);
        this.cache.put(id, data);
        return data;
    }

    private EnderChestData readDataFromFile(UUID playerId) {
        EnderChestData data = new EnderChestData();
        Path file = this.filePath(playerId);
        if (Files.exists(file, new LinkOption[0])) {
            try (InputStream input = Files.newInputStream(file, StandardOpenOption.READ);){
                CompoundTag tag = NbtIo.readCompressed((InputStream)input, (NbtAccounter)NbtAccounter.unlimitedHeap());
                if (tag != null) {
                    data.load(tag, (HolderLookup.Provider)this.server.registryAccess());
                }
            }
            catch (IOException exception) {
                Constants.LOG.error("Failed to read ender chest data for {}", (Object)playerId, (Object)exception);
            }
        }
        data.setChangeListener(() -> this.save(playerId, data));
        return data;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EnderChestData readDataFromDatabase(UUID playerId) {
        EnderChestData data = new EnderChestData();
        if (playerId == null) {
            return data;
        }
        try (Connection connection = this.database.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT last_known_name, nbt_payload FROM foundryx_ender_chests WHERE player_uuid=?");){
            statement.setString(1, playerId.toString());
            try (ResultSet resultSet = statement.executeQuery();){
                String lastKnown;
                if (!resultSet.next()) {
                    EnderChestData enderChestData = data;
                    return enderChestData;
                }
                String encoded = resultSet.getString("nbt_payload");
                if (encoded != null && !encoded.isBlank()) {
                    byte[] payload = Base64.getDecoder().decode(encoded);
                    try (ByteArrayInputStream input = new ByteArrayInputStream(payload);){
                        CompoundTag tag = NbtIo.readCompressed((InputStream)input, (NbtAccounter)NbtAccounter.unlimitedHeap());
                        if (tag != null) {
                            data.load(tag, (HolderLookup.Provider)this.server.registryAccess());
                        }
                    }
                }
                if ((lastKnown = resultSet.getString("last_known_name")) != null && !lastKnown.isBlank()) {
                    data.updateLastKnownUsername(lastKnown);
                }
            }
        }
        catch (IOException | SQLException exception) {
            Constants.LOG.error("Failed to read ender chest data for {}", (Object)playerId, (Object)exception);
        }
        data.setChangeListener(() -> this.save(playerId, data));
        return data;
    }

    private void save(UUID playerId, EnderChestData data) {
        if (this.useDatabase) {
            this.saveToDatabase(playerId, data);
            return;
        }
        this.saveToFile(playerId, data);
    }

    private void saveToFile(UUID playerId, EnderChestData data) {
        Path file = this.filePath(playerId);
        try {
            Files.createDirectories(this.directory, new FileAttribute[0]);
            CompoundTag tag = data.save((HolderLookup.Provider)this.server.registryAccess());
            try (OutputStream output = Files.newOutputStream(file, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
                NbtIo.writeCompressed((CompoundTag)tag, (OutputStream)output);
            }
        }
        catch (IOException exception) {
            Constants.LOG.error("Failed to write ender chest data for {}", (Object)playerId, (Object)exception);
        }
    }

    private void saveToDatabase(UUID playerId, EnderChestData data) {
        if (playerId == null) {
            return;
        }
        String encoded = this.encodePayload(data);
        String lastKnown = data.getLastKnownUsername();
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            try (PreparedStatement update = connection.prepareStatement("UPDATE foundryx_ender_chests SET last_known_name=?, nbt_payload=? WHERE player_uuid=?");){
                this.setNullableString(update, 1, lastKnown);
                this.setNullableString(update, 2, encoded);
                update.setString(3, playerId.toString());
                int updated = update.executeUpdate();
                if (updated == 0) {
                    try (PreparedStatement insert = connection.prepareStatement("INSERT INTO foundryx_ender_chests (player_uuid, last_known_name, nbt_payload) VALUES (?,?,?)");){
                        insert.setString(1, playerId.toString());
                        this.setNullableString(insert, 2, lastKnown);
                        this.setNullableString(insert, 3, encoded);
                        insert.executeUpdate();
                    }
                }
                connection.commit();
            }
            catch (SQLException exception) {
                connection.rollback();
                throw exception;
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException exception) {
            Constants.LOG.error("Failed to persist ender chest data for {}", (Object)playerId, (Object)exception);
        }
    }

    private String encodePayload(EnderChestData data) {
        String string;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            CompoundTag tag = data.save((HolderLookup.Provider)this.server.registryAccess());
            NbtIo.writeCompressed((CompoundTag)tag, (OutputStream)output);
            byte[] payload = output.toByteArray();
            string = payload.length == 0 ? null : Base64.getEncoder().encodeToString(payload);
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                Constants.LOG.error("Failed to encode ender chest payload", (Throwable)exception);
                return null;
            }
        }
        output.close();
        return string;
    }

    private void setNullableString(PreparedStatement statement, int index, String value) throws SQLException {
        if (value == null || value.isBlank()) {
            statement.setNull(index, 12);
        } else {
            statement.setString(index, value);
        }
    }

    /*
     * Exception decompiling
     */
    private EnderChestData loadFromDatabaseByName(String normalized) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Path filePath(UUID playerId) {
        return this.directory.resolve(playerId.toString() + ".nbt");
    }

    private static UUID parseFileId(String name) {
        int dot = name.lastIndexOf(46);
        String idPart = dot >= 0 ? name.substring(0, dot) : name;
        try {
            return UUID.fromString(idPart);
        }
        catch (IllegalArgumentException exception) {
            return null;
        }
    }
}

