/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.managers;

import com.foundryx.Constants;
import com.foundryx.data.HomeData;
import com.foundryx.storage.FoundryxDataStorage;
import com.foundryx.storage.database.DatabaseContext;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;

public final class HomeDataManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type LOCATION_MAP_TYPE = new TypeToken<Map<String, FoundryxDataStorage.LocationSnapshot>>(){}.getType();
    private final Path directory;
    private final Map<UUID, HomeData> cache = new HashMap<UUID, HomeData>();
    private final boolean useDatabase;
    private final DatabaseContext database;

    public HomeDataManager(Path directory) {
        this(directory, null);
    }

    public HomeDataManager(Path directory, DatabaseContext database) {
        this.directory = directory;
        this.database = database;
        this.useDatabase = database != null && database.isAvailable();
    }

    public void setHome(UUID player, String name, ServerPlayer owner) {
        if (this.useDatabase) {
            if (player == null || name == null || owner == null) {
                return;
            }
            this.setHomeDatabase(player, name, FoundryxDataStorage.LocationSnapshot.from(owner));
            return;
        }
        HomeData homes = this.load(player);
        homes.set(name, FoundryxDataStorage.LocationSnapshot.from(owner));
        this.save(player, homes);
    }

    public Optional<FoundryxDataStorage.TeleportTarget> getHome(UUID player, String name) {
        if (this.useDatabase) {
            return this.getHomeDatabase(player, name).flatMap(FoundryxDataStorage.LocationSnapshot::toTeleportTarget);
        }
        return this.load(player).get(name).flatMap(FoundryxDataStorage.LocationSnapshot::toTeleportTarget);
    }

    public boolean deleteHome(UUID player, String name) {
        if (this.useDatabase) {
            return this.deleteHomeDatabase(player, name);
        }
        HomeData homes = this.load(player);
        if (!homes.remove(name)) {
            return false;
        }
        this.save(player, homes);
        return true;
    }

    public Collection<String> getHomeNames(UUID player) {
        if (this.useDatabase) {
            return this.getHomeNamesDatabase(player);
        }
        return this.load(player).names();
    }

    private HomeData load(UUID player) {
        if (this.useDatabase) {
            return this.readHomesFromDatabase(player);
        }
        return this.cache.computeIfAbsent(player, this::readHomes);
    }

    private HomeData readHomes(UUID player) {
        HomeData homeData;
        block9: {
            Path file = this.filePath(player);
            if (!Files.exists(file, new LinkOption[0])) {
                return new HomeData();
            }
            BufferedReader reader = Files.newBufferedReader(file);
            try {
                Map loaded = (Map)GSON.fromJson((Reader)reader, LOCATION_MAP_TYPE);
                homeData = new HomeData(loaded);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    Constants.LOG.error("Failed to read homes for {}", (Object)player, (Object)exception);
                    return new HomeData();
                }
            }
            ((Reader)reader).close();
        }
        return homeData;
    }

    private void save(UUID player, HomeData homes) {
        if (this.useDatabase) {
            return;
        }
        Path file = this.filePath(player);
        try {
            if (homes.isEmpty()) {
                this.cache.remove(player);
                Files.deleteIfExists(file);
                return;
            }
            Files.createDirectories(this.directory, new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(file, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
                GSON.toJson(homes.asMap(), LOCATION_MAP_TYPE, (Appendable)writer);
            }
        }
        catch (IOException exception) {
            Constants.LOG.error("Failed to write homes for {}", (Object)player, (Object)exception);
        }
    }

    private Path filePath(UUID player) {
        return this.directory.resolve(player.toString() + ".json");
    }

    public void flush() {
    }

    private void setHomeDatabase(UUID player, String name, FoundryxDataStorage.LocationSnapshot snapshot) {
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            String key = this.normalise(name);
            try (PreparedStatement update = connection.prepareStatement("UPDATE foundryx_home_data SET dimension=?, x=?, y=?, z=?, yaw=?, pitch=? WHERE player_uuid=? AND home_name=?");){
                this.bindLocation(update, snapshot);
                update.setString(7, player.toString());
                update.setString(8, key);
                int updated = update.executeUpdate();
                if (updated == 0) {
                    try (PreparedStatement insert = connection.prepareStatement("INSERT INTO foundryx_home_data (player_uuid, home_name, dimension, x, y, z, yaw, pitch) VALUES (?,?,?,?,?,?,?,?)");){
                        insert.setString(1, player.toString());
                        insert.setString(2, key);
                        this.bindLocation(insert, 3, snapshot);
                        insert.executeUpdate();
                    }
                }
                connection.commit();
            }
            catch (SQLException exception) {
                connection.rollback();
                throw exception;
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException exception) {
            Constants.LOG.error("Failed to persist home '{}' for {}", new Object[]{name, player, exception});
        }
    }

    /*
     * Exception decompiling
     */
    private Optional<FoundryxDataStorage.LocationSnapshot> getHomeDatabase(UUID player, String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean deleteHomeDatabase(UUID player, String name) {
        if (player == null || name == null) {
            return false;
        }
        try (Connection connection = this.database.getConnection();){
            boolean bl;
            block15: {
                PreparedStatement statement = connection.prepareStatement("DELETE FROM foundryx_home_data WHERE player_uuid=? AND home_name=?");
                try {
                    statement.setString(1, player.toString());
                    statement.setString(2, this.normalise(name));
                    boolean bl2 = bl = statement.executeUpdate() > 0;
                    if (statement == null) break block15;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (SQLException exception) {
            Constants.LOG.error("Failed to delete home '{}' for {}", new Object[]{name, player, exception});
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    private Collection<String> getHomeNamesDatabase(UUID player) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private HomeData readHomesFromDatabase(UUID player) {
        HomeData data = new HomeData();
        if (player == null) {
            return data;
        }
        try (Connection connection = this.database.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT home_name, dimension, x, y, z, yaw, pitch FROM foundryx_home_data WHERE player_uuid=?");){
            statement.setString(1, player.toString());
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    String name = resultSet.getString("home_name");
                    FoundryxDataStorage.LocationSnapshot snapshot = this.mapSnapshot(resultSet);
                    if (name == null || snapshot == null) continue;
                    data.set(name, snapshot);
                }
            }
        }
        catch (SQLException exception) {
            Constants.LOG.error("Failed to read homes for {}", (Object)player, (Object)exception);
        }
        return data;
    }

    private void bindLocation(PreparedStatement statement, FoundryxDataStorage.LocationSnapshot snapshot) throws SQLException {
        this.bindLocation(statement, 1, snapshot);
    }

    private void bindLocation(PreparedStatement statement, int offset, FoundryxDataStorage.LocationSnapshot snapshot) throws SQLException {
        statement.setString(offset, snapshot.dimension());
        statement.setDouble(offset + 1, snapshot.x());
        statement.setDouble(offset + 2, snapshot.y());
        statement.setDouble(offset + 3, snapshot.z());
        statement.setFloat(offset + 4, snapshot.yaw());
        statement.setFloat(offset + 5, snapshot.pitch());
    }

    private FoundryxDataStorage.LocationSnapshot mapSnapshot(ResultSet resultSet) throws SQLException {
        String dimension = resultSet.getString("dimension");
        double x = resultSet.getDouble("x");
        double y = resultSet.getDouble("y");
        double z = resultSet.getDouble("z");
        float yaw = resultSet.getFloat("yaw");
        float pitch = resultSet.getFloat("pitch");
        if (dimension == null) {
            return null;
        }
        return new FoundryxDataStorage.LocationSnapshot(dimension, x, y, z, yaw, pitch);
    }

    private String normalise(String name) {
        return name.toLowerCase(Locale.ROOT);
    }
}

