/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.managers;

import com.foundryx.Constants;
import com.foundryx.data.JailData;
import com.foundryx.storage.FoundryxDataStorage;
import com.foundryx.storage.database.DatabaseContext;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public final class JailDataManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Path directory;
    private final Path file;
    private final JailData jailData = new JailData();
    private final boolean useDatabase;
    private final DatabaseContext database;

    public JailDataManager(Path directory) {
        this(directory, null);
    }

    public JailDataManager(Path directory, DatabaseContext database) {
        this.directory = directory;
        this.file = directory.resolve("region.json");
        this.database = database;
        this.useDatabase = database != null && database.isAvailable();
        this.load();
    }

    public void setRegion(ResourceKey<Level> dimension, BlockPos first, BlockPos second, float yaw, float pitch) {
        FoundryxDataStorage.BlockPosition minimum = new FoundryxDataStorage.BlockPosition(first.getX(), first.getY(), first.getZ());
        FoundryxDataStorage.BlockPosition maximum = new FoundryxDataStorage.BlockPosition(second.getX(), second.getY(), second.getZ());
        this.jailData.setRegion(new FoundryxDataStorage.JailRegion(dimension.location().toString(), minimum, maximum, yaw, pitch));
        this.save();
    }

    public Optional<FoundryxDataStorage.JailRegion> getRegion() {
        return this.jailData.getRegion();
    }

    public boolean deleteRegion() {
        if (!this.jailData.clearRegion()) {
            return false;
        }
        this.save();
        return true;
    }

    private void load() {
        if (this.useDatabase) {
            this.loadFromDatabase();
            return;
        }
        if (!Files.exists(this.file, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(this.file);){
            FoundryxDataStorage.JailRegion region = (FoundryxDataStorage.JailRegion)GSON.fromJson((Reader)reader, FoundryxDataStorage.JailRegion.class);
            this.jailData.loadRegion(region);
        }
        catch (IOException exception) {
            Constants.LOG.error("Failed to read jail data", (Throwable)exception);
        }
    }

    private void save() {
        if (this.useDatabase) {
            this.saveToDatabase();
            return;
        }
        try {
            Optional<FoundryxDataStorage.JailRegion> region = this.jailData.getRegion();
            if (region.isEmpty()) {
                Files.deleteIfExists(this.file);
                return;
            }
            Files.createDirectories(this.directory, new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(this.file, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
                GSON.toJson((Object)region.get(), (Appendable)writer);
            }
        }
        catch (IOException exception) {
            Constants.LOG.error("Failed to write jail data", (Throwable)exception);
        }
    }

    public void flush() {
        if (this.useDatabase) {
            this.saveToDatabase();
        }
    }

    private void loadFromDatabase() {
        try (Connection connection = this.database.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT dimension, min_x, min_y, min_z, max_x, max_y, max_z, yaw, pitch FROM foundryx_jail_data WHERE id=1");
             ResultSet resultSet = statement.executeQuery();){
            if (resultSet.next()) {
                FoundryxDataStorage.JailRegion region = this.mapRegion(resultSet);
                this.jailData.loadRegion(region);
            }
        }
        catch (SQLException exception) {
            Constants.LOG.error("Failed to load jail region from database", (Throwable)exception);
        }
    }

    private void saveToDatabase() {
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            try {
                block32: {
                    Optional<FoundryxDataStorage.JailRegion> region = this.jailData.getRegion();
                    if (region.isEmpty()) {
                        try (PreparedStatement delete = connection.prepareStatement("DELETE FROM foundryx_jail_data WHERE id=1");){
                            delete.executeUpdate();
                        }
                    }
                    FoundryxDataStorage.JailRegion value = region.get();
                    try (PreparedStatement update = connection.prepareStatement("UPDATE foundryx_jail_data SET dimension=?, min_x=?, min_y=?, min_z=?, max_x=?, max_y=?, max_z=?, yaw=?, pitch=? WHERE id=1");){
                        this.bindRegion(update, value);
                        if (update.executeUpdate() != 0) break block32;
                        try (PreparedStatement insert = connection.prepareStatement("INSERT INTO foundryx_jail_data (id, dimension, min_x, min_y, min_z, max_x, max_y, max_z, yaw, pitch) VALUES (1,?,?,?,?,?,?,?,?,?)");){
                            this.bindRegion(insert, value);
                            insert.executeUpdate();
                        }
                    }
                }
                connection.commit();
            }
            catch (SQLException exception) {
                connection.rollback();
                throw exception;
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException exception) {
            Constants.LOG.error("Failed to persist jail region", (Throwable)exception);
        }
    }

    private FoundryxDataStorage.JailRegion mapRegion(ResultSet resultSet) throws SQLException {
        String dimension = resultSet.getString("dimension");
        if (dimension == null) {
            return null;
        }
        FoundryxDataStorage.BlockPosition min = new FoundryxDataStorage.BlockPosition(resultSet.getInt("min_x"), resultSet.getInt("min_y"), resultSet.getInt("min_z"));
        FoundryxDataStorage.BlockPosition max = new FoundryxDataStorage.BlockPosition(resultSet.getInt("max_x"), resultSet.getInt("max_y"), resultSet.getInt("max_z"));
        float yaw = resultSet.getFloat("yaw");
        float pitch = resultSet.getFloat("pitch");
        return new FoundryxDataStorage.JailRegion(dimension, min, max, yaw, pitch);
    }

    private void bindRegion(PreparedStatement statement, FoundryxDataStorage.JailRegion region) throws SQLException {
        this.bindRegion(statement, 1, region);
    }

    private void bindRegion(PreparedStatement statement, int offset, FoundryxDataStorage.JailRegion region) throws SQLException {
        statement.setString(offset, region.dimension());
        statement.setInt(offset + 1, region.minimum().x());
        statement.setInt(offset + 2, region.minimum().y());
        statement.setInt(offset + 3, region.minimum().z());
        statement.setInt(offset + 4, region.maximum().x());
        statement.setInt(offset + 5, region.maximum().y());
        statement.setInt(offset + 6, region.maximum().z());
        statement.setFloat(offset + 7, region.yaw());
        statement.setFloat(offset + 8, region.pitch());
    }
}

