/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.managers;

import com.foundryx.Constants;
import com.foundryx.data.SpawnData;
import com.foundryx.storage.FoundryxDataStorage;
import com.foundryx.storage.database.DatabaseContext;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Optional;

public final class SpawnManager {
    private final Path directory;
    private final Path file;
    private final Gson gson;
    private final boolean useDatabase;
    private final DatabaseContext database;
    private SpawnData spawnData = new SpawnData();

    public SpawnManager(Path directory, Gson gson) {
        this(directory, gson, null);
    }

    public SpawnManager(Path directory, Gson gson, DatabaseContext database) {
        this.directory = Objects.requireNonNull(directory, "directory");
        this.file = directory.resolve("spawn.json");
        this.gson = Objects.requireNonNull(gson, "gson");
        this.database = database;
        this.useDatabase = database != null && database.isAvailable();
        this.load();
    }

    public Optional<FoundryxDataStorage.TeleportTarget> getSpawn() {
        return this.spawnData.getLocation().flatMap(FoundryxDataStorage.LocationSnapshot::toTeleportTarget);
    }

    public void setSpawn(FoundryxDataStorage.LocationSnapshot snapshot) {
        this.spawnData.setLocation(snapshot);
        this.save();
    }

    private void load() {
        if (this.useDatabase) {
            this.loadFromDatabase();
            return;
        }
        if (!Files.exists(this.file, new LinkOption[0])) {
            this.spawnData = new SpawnData();
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(this.file);){
            LoadedSpawnData loaded = this.deserializeSpawnData(JsonParser.parseReader((Reader)reader));
            this.spawnData = loaded.data();
            if (loaded.migrated()) {
                this.save();
            }
        }
        catch (JsonParseException | IOException exception) {
            Constants.LOG.error("Failed to read spawn data", exception);
            this.spawnData = new SpawnData();
        }
    }

    private LoadedSpawnData deserializeSpawnData(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return new LoadedSpawnData(new SpawnData(), false);
        }
        if (!element.isJsonObject()) {
            Constants.LOG.warn("Unexpected spawn data format: {}", (Object)element);
            return new LoadedSpawnData(new SpawnData(), false);
        }
        JsonObject object = element.getAsJsonObject();
        if (object.has("location")) {
            SpawnData loaded = (SpawnData)this.gson.fromJson((JsonElement)object, SpawnData.class);
            return new LoadedSpawnData(loaded != null ? loaded : new SpawnData(), false);
        }
        FoundryxDataStorage.LocationSnapshot snapshot = (FoundryxDataStorage.LocationSnapshot)this.gson.fromJson((JsonElement)object, FoundryxDataStorage.LocationSnapshot.class);
        if (snapshot == null) {
            return new LoadedSpawnData(new SpawnData(), false);
        }
        SpawnData migrated = new SpawnData();
        migrated.setLocation(snapshot);
        Constants.LOG.info("Migrated legacy spawn data schema to SpawnData container");
        return new LoadedSpawnData(migrated, true);
    }

    private void save() {
        if (this.useDatabase) {
            this.saveToDatabase();
            return;
        }
        try {
            if (this.spawnData.isEmpty()) {
                Files.deleteIfExists(this.file);
                return;
            }
            Files.createDirectories(this.directory, new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(this.file, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
                this.gson.toJson((Object)this.spawnData, (Appendable)writer);
            }
        }
        catch (IOException exception) {
            Constants.LOG.error("Failed to write spawn data", (Throwable)exception);
        }
    }

    public void flush() {
        if (this.useDatabase) {
            this.saveToDatabase();
        }
    }

    private void loadFromDatabase() {
        this.spawnData = new SpawnData();
        try (Connection connection = this.database.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT dimension, x, y, z, yaw, pitch FROM foundryx_spawn_points WHERE id=1");
             ResultSet resultSet = statement.executeQuery();){
            FoundryxDataStorage.LocationSnapshot snapshot;
            if (resultSet.next() && (snapshot = this.mapSnapshot(resultSet)) != null) {
                this.spawnData.setLocation(snapshot);
            }
        }
        catch (SQLException exception) {
            Constants.LOG.error("Failed to load spawn from database", (Throwable)exception);
        }
    }

    private void saveToDatabase() {
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            try {
                block32: {
                    Optional<FoundryxDataStorage.LocationSnapshot> location = this.spawnData.getLocation();
                    if (location.isEmpty()) {
                        try (PreparedStatement delete = connection.prepareStatement("DELETE FROM foundryx_spawn_points WHERE id=1");){
                            delete.executeUpdate();
                        }
                    }
                    FoundryxDataStorage.LocationSnapshot snapshot = location.get();
                    try (PreparedStatement update = connection.prepareStatement("UPDATE foundryx_spawn_points SET dimension=?, x=?, y=?, z=?, yaw=?, pitch=? WHERE id=1");){
                        this.bindSnapshot(update, snapshot);
                        if (update.executeUpdate() != 0) break block32;
                        try (PreparedStatement insert = connection.prepareStatement("INSERT INTO foundryx_spawn_points (id, dimension, x, y, z, yaw, pitch) VALUES (1,?,?,?,?,?,?)");){
                            this.bindSnapshot(insert, snapshot);
                            insert.executeUpdate();
                        }
                    }
                }
                connection.commit();
            }
            catch (SQLException exception) {
                connection.rollback();
                throw exception;
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException exception) {
            Constants.LOG.error("Failed to persist spawn data", (Throwable)exception);
        }
    }

    private FoundryxDataStorage.LocationSnapshot mapSnapshot(ResultSet resultSet) throws SQLException {
        String dimension = resultSet.getString("dimension");
        if (dimension == null) {
            return null;
        }
        double x = resultSet.getDouble("x");
        double y = resultSet.getDouble("y");
        double z = resultSet.getDouble("z");
        float yaw = resultSet.getFloat("yaw");
        float pitch = resultSet.getFloat("pitch");
        return new FoundryxDataStorage.LocationSnapshot(dimension, x, y, z, yaw, pitch);
    }

    private void bindSnapshot(PreparedStatement statement, FoundryxDataStorage.LocationSnapshot snapshot) throws SQLException {
        this.bindSnapshot(statement, 1, snapshot);
    }

    private void bindSnapshot(PreparedStatement statement, int offset, FoundryxDataStorage.LocationSnapshot snapshot) throws SQLException {
        statement.setString(offset, snapshot.dimension());
        statement.setDouble(offset + 1, snapshot.x());
        statement.setDouble(offset + 2, snapshot.y());
        statement.setDouble(offset + 3, snapshot.z());
        statement.setFloat(offset + 4, snapshot.yaw());
        statement.setFloat(offset + 5, snapshot.pitch());
    }

    private record LoadedSpawnData(SpawnData data, boolean migrated) {
        private LoadedSpawnData(SpawnData data, boolean migrated) {
            this.data = data = Objects.requireNonNullElse(data, new SpawnData());
            this.migrated = migrated;
        }
    }
}

