/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.managers;

import com.foundryx.chat.ChatFormatter;
import com.foundryx.config.ModConfig;
import com.foundryx.managers.VanishManager;
import com.foundryx.permission.LuckPermsMetaUtil;
import com.foundryx.platform.Services;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.scores.PlayerTeam;

public final class TabManager {
    private static final Component SPACE = Component.literal((String)" ");
    private static final Map<UUID, Component> DISPLAY_CACHE = new ConcurrentHashMap<UUID, Component>();
    private static final String TEAM_PREFIX = "foundryx_tab_";
    private static final Map<MinecraftServer, Integer> TICKS_UNTIL_REFRESH = new WeakHashMap<MinecraftServer, Integer>();
    private static final int MIN_GROUP_WEIGHT = -999;
    private static final int MAX_GROUP_WEIGHT = 9999;
    private static final int GROUP_WEIGHT_RANGE = 10998;

    private TabManager() {
    }

    public static void updateTabName(ServerPlayer player) {
        if (VanishManager.isVanished(player)) {
            TabManager.clearCachedDisplay(player.getUUID());
            Services.PLATFORM.clearTabDisplay(player);
            return;
        }
        MinecraftServer server = TabManager.resolveServer(player);
        if (server == null) {
            return;
        }
        server.execute(() -> TabManager.applyTabDisplay(player, LuckPermsMetaUtil.getPrefix(player), LuckPermsMetaUtil.getSuffix(player), LuckPermsMetaUtil.getWeight(player), true));
    }

    public static void handlePlayerJoin(ServerPlayer player) {
        if (VanishManager.isVanished(player)) {
            TabManager.clearCachedDisplay(player.getUUID());
            Services.PLATFORM.clearTabDisplay(player);
            return;
        }
        TabManager.updateTabName(player);
    }

    public static void handleServerTick(MinecraftServer server) {
        int intervalSeconds = ModConfig.get().tab().tabUpdateInterval();
        if (intervalSeconds <= 0) {
            TICKS_UNTIL_REFRESH.remove(server);
            return;
        }
        int ticksRemaining = TICKS_UNTIL_REFRESH.getOrDefault(server, intervalSeconds * 20);
        if (--ticksRemaining <= 0) {
            TabManager.updateAll(server);
            ticksRemaining = intervalSeconds * 20;
        }
        TICKS_UNTIL_REFRESH.put(server, ticksRemaining);
    }

    public static void updateAll(MinecraftServer server) {
        server.getPlayerList().getPlayers().forEach(TabManager::updateTabName);
    }

    public static Component getDisplay(ServerPlayer player) {
        if (VanishManager.isVanished(player)) {
            return Component.empty();
        }
        Component cached = DISPLAY_CACHE.get(player.getUUID());
        if (cached != null) {
            return cached.copy();
        }
        return TabManager.applyTabDisplay(player, LuckPermsMetaUtil.getPrefix(player), LuckPermsMetaUtil.getSuffix(player), LuckPermsMetaUtil.getWeight(player), false).copy();
    }

    public static Component getCachedDisplay(UUID uuid) {
        Component cached = DISPLAY_CACHE.get(uuid);
        return cached != null ? cached.copy() : null;
    }

    public static void clearCachedDisplay(UUID uuid) {
        if (uuid != null) {
            DISPLAY_CACHE.remove(uuid);
        }
    }

    public static void handlePlayerQuit(ServerPlayer player) {
        TabManager.clearCachedDisplay(player.getUUID());
        TabManager.removeFromGroupTeam(player);
        Services.PLATFORM.clearTabDisplay(player);
    }

    private static Component applyTabDisplay(ServerPlayer player, String prefix, String suffix, int groupWeight, boolean refresh) {
        if (player == null || player.isRemoved()) {
            return Component.empty();
        }
        MinecraftServer server = TabManager.resolveServer(player);
        MutableComponent display = TabManager.buildDisplayComponent(player, prefix, suffix);
        MutableComponent frozen = display.copy();
        DISPLAY_CACHE.put(player.getUUID(), (Component)frozen);
        if (server != null) {
            TabManager.updateGroupTeam(server, player, groupWeight);
            boolean handled = Services.PLATFORM.updateTabDisplay(player, (Component)frozen);
            if (refresh && !handled) {
                PlayerList playerList = server.getPlayerList();
                playerList.broadcastAll((Packet)new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME, player));
            }
        }
        return frozen;
    }

    private static MutableComponent buildDisplayComponent(ServerPlayer player, String prefix, String suffix) {
        Component parsedSuffix;
        Component parsedPrefix;
        MutableComponent display = Component.empty();
        if (prefix != null && !prefix.isBlank() && !TabManager.isComponentEmpty(parsedPrefix = ChatFormatter.legacyToComponent(prefix))) {
            display.append((Component)parsedPrefix.copy());
            if (!TabManager.componentEndsWithWhitespace((Component)display) && !TabManager.hasTrailingWhitespace(prefix)) {
                display.append((Component)SPACE.copy());
            }
        }
        MutableComponent baseDisplay = ChatFormatter.formatDisplayName(player);
        display.append((Component)baseDisplay);
        if (suffix != null && !suffix.isBlank() && !TabManager.isComponentEmpty(parsedSuffix = ChatFormatter.legacyToComponent(suffix))) {
            if (!TabManager.componentEndsWithWhitespace((Component)display) && !TabManager.hasLeadingWhitespace(suffix)) {
                display.append((Component)SPACE.copy());
            }
            display.append((Component)parsedSuffix.copy());
        }
        return display;
    }

    private static void updateGroupTeam(MinecraftServer server, ServerPlayer player, int groupWeight) {
        PlayerTeam currentTeam;
        ServerScoreboard scoreboard = server.getScoreboard();
        String scoreboardName = player.getScoreboardName();
        int clamped = Math.max(Math.min(groupWeight, 9999), -999);
        int normalized = clamped - -999;
        int order = 10998 - normalized;
        String teamName = TEAM_PREFIX + String.format(Locale.ROOT, "%05d", order);
        PlayerTeam desiredTeam = scoreboard.getPlayerTeam(teamName);
        if (desiredTeam == null) {
            desiredTeam = scoreboard.addPlayerTeam(teamName);
        }
        if (desiredTeam.getColor() != ChatFormatting.RESET) {
            desiredTeam.setColor(ChatFormatting.RESET);
        }
        if ((currentTeam = scoreboard.getPlayersTeam(scoreboardName)) != null && currentTeam.getName().equals(desiredTeam.getName())) {
            return;
        }
        if (currentTeam != null && !TabManager.isTabTeam(currentTeam)) {
            return;
        }
        if (currentTeam != null && TabManager.isTabTeam(currentTeam)) {
            scoreboard.removePlayerFromTeam(scoreboardName);
            if (currentTeam.getPlayers().isEmpty()) {
                scoreboard.removePlayerTeam(currentTeam);
            }
        }
        scoreboard.addPlayerToTeam(scoreboardName, desiredTeam);
    }

    private static void removeFromGroupTeam(ServerPlayer player) {
        String scoreboardName;
        MinecraftServer server = TabManager.resolveServer(player);
        if (server == null) {
            return;
        }
        ServerScoreboard scoreboard = server.getScoreboard();
        PlayerTeam currentTeam = scoreboard.getPlayersTeam(scoreboardName = player.getScoreboardName());
        if (currentTeam != null && TabManager.isTabTeam(currentTeam)) {
            scoreboard.removePlayerFromTeam(scoreboardName);
            if (currentTeam.getPlayers().isEmpty()) {
                scoreboard.removePlayerTeam(currentTeam);
            }
        }
    }

    private static boolean hasTrailingWhitespace(String value) {
        if (value.isEmpty()) {
            return false;
        }
        return Character.isWhitespace(value.charAt(value.length() - 1));
    }

    private static boolean hasLeadingWhitespace(String value) {
        if (value.isEmpty()) {
            return false;
        }
        return Character.isWhitespace(value.charAt(0));
    }

    private static boolean isComponentEmpty(Component component) {
        return component == null || component.getString().isEmpty() && component.getSiblings().isEmpty();
    }

    private static boolean componentEndsWithWhitespace(Component component) {
        if (component == null) {
            return false;
        }
        String value = component.getString();
        return !value.isEmpty() && Character.isWhitespace(value.charAt(value.length() - 1));
    }

    public static boolean isTabTeam(PlayerTeam team) {
        return team != null && team.getName().startsWith(TEAM_PREFIX);
    }

    private static MinecraftServer resolveServer(ServerPlayer player) {
        if (player == null) {
            return null;
        }
        ServerLevel serverLevel = player.level();
        if (serverLevel instanceof ServerLevel) {
            ServerLevel serverLevel2 = serverLevel;
            return serverLevel2.getServer();
        }
        return null;
    }
}

