/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.managers;

import com.foundryx.permission.FoundryxPermissions;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;

public final class VanishManager {
    private static final Set<UUID> VANISHED_PLAYERS = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final ConcurrentHashMap<UUID, TeamState> TEAM_STATES = new ConcurrentHashMap();
    private static final String VANISH_TEAM_NAME = "essx_vanish";
    private static final String VANISH_SEE_PERMISSION = "foundryx.vanish.see";

    private VanishManager() {
    }

    public static boolean isVanished(ServerPlayer player) {
        return VANISHED_PLAYERS.contains(player.getUUID());
    }

    public static void setVanished(ServerPlayer player, boolean vanished) {
        if (vanished) {
            VANISHED_PLAYERS.add(player.getUUID());
            VanishManager.apply(player);
        } else {
            VANISHED_PLAYERS.remove(player.getUUID());
            VanishManager.reveal(player);
        }
    }

    public static void toggle(ServerPlayer player) {
        VanishManager.setVanished(player, !VanishManager.isVanished(player));
    }

    public static void apply(ServerPlayer player) {
        player.setInvisible(true);
        player.setSilent(true);
        VanishManager.refreshTeamMembership(VanishManager.getServer(player));
        VanishManager.hideFromOthers(player);
    }

    public static void reveal(ServerPlayer player) {
        player.setInvisible(false);
        player.setSilent(false);
        VanishManager.refreshTeamMembership(VanishManager.getServer(player));
        VanishManager.showToOthers(player);
    }

    public static void handleJoin(ServerPlayer joinedPlayer) {
        VanishManager.refreshTeamMembership(VanishManager.getServer(joinedPlayer));
        if (VanishManager.isVanished(joinedPlayer)) {
            VanishManager.apply(joinedPlayer);
            return;
        }
        MinecraftServer server = VanishManager.getServer(joinedPlayer);
        if (server == null) {
            return;
        }
        for (UUID uuid : VANISHED_PLAYERS) {
            ServerPlayer vanished = server.getPlayerList().getPlayer(uuid);
            if (vanished == null) continue;
            joinedPlayer.connection.send((Packet)new ClientboundPlayerInfoRemovePacket(List.of(uuid)));
            joinedPlayer.connection.send((Packet)new ClientboundRemoveEntitiesPacket(new int[]{vanished.getId()}));
        }
    }

    public static void handleQuit(ServerPlayer player) {
        MinecraftServer server = VanishManager.getServer(player);
        if (server == null) {
            return;
        }
        VanishManager.restoreTeam(server, player.getUUID());
    }

    public static void handlePlayerJoin(ServerPlayer player) {
        VanishManager.handleJoin(player);
    }

    public static void handlePlayerQuit(ServerPlayer player) {
        VanishManager.handleQuit(player);
    }

    public static void handlePlayerTick(ServerPlayer player) {
    }

    private static void hideFromOthers(ServerPlayer vanished) {
        MinecraftServer server = VanishManager.getServer(vanished);
        if (server == null) {
            return;
        }
        ClientboundPlayerInfoRemovePacket removePacket = new ClientboundPlayerInfoRemovePacket(List.of(vanished.getUUID()));
        ClientboundRemoveEntitiesPacket removeEntitiesPacket = new ClientboundRemoveEntitiesPacket(new int[]{vanished.getId()});
        for (ServerPlayer other : server.getPlayerList().getPlayers()) {
            if (other == vanished) continue;
            other.connection.send((Packet)removePacket);
            other.connection.send((Packet)removeEntitiesPacket);
        }
    }

    private static void showToOthers(ServerPlayer player) {
        MinecraftServer server = VanishManager.getServer(player);
        if (server == null) {
            return;
        }
        ClientboundPlayerInfoUpdatePacket addPacket = new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER), List.of(player));
        ServerEntity serverEntity = VanishManager.createServerEntity(player);
        for (ServerPlayer other : server.getPlayerList().getPlayers()) {
            if (other == player) continue;
            other.connection.send((Packet)addPacket);
            serverEntity.sendPairingData(other, arg_0 -> ((ServerGamePacketListenerImpl)other.connection).send(arg_0));
        }
    }

    public static boolean canSeeVanished(ServerPlayer player) {
        return VanishManager.isVanished(player) || FoundryxPermissions.check(player, VANISH_SEE_PERMISSION, 3);
    }

    private static void refreshTeamMembership(MinecraftServer server) {
        if (server == null) {
            return;
        }
        if (VANISHED_PLAYERS.isEmpty() || !VanishManager.hasOnlineVanished(server)) {
            VanishManager.clearTeam(server);
            return;
        }
        PlayerTeam vanishTeam = VanishManager.getOrCreateVanishTeam(server);
        if (vanishTeam == null) {
            return;
        }
        for (ServerPlayer online : server.getPlayerList().getPlayers()) {
            UUID uuid = online.getUUID();
            if (VANISHED_PLAYERS.contains(uuid) || VanishManager.canSeeVanished(online)) {
                VanishManager.addToVanishTeam(server, vanishTeam, online);
                continue;
            }
            if (!TEAM_STATES.containsKey(uuid)) continue;
            VanishManager.restoreTeam(server, uuid);
        }
    }

    private static PlayerTeam getOrCreateVanishTeam(MinecraftServer server) {
        ServerScoreboard scoreboard = server.getScoreboard();
        PlayerTeam team = scoreboard.getPlayerTeam(VANISH_TEAM_NAME);
        if (team != null) {
            return team;
        }
        team = scoreboard.addPlayerTeam(VANISH_TEAM_NAME);
        team.setSeeFriendlyInvisibles(true);
        team.setCollisionRule(Team.CollisionRule.NEVER);
        return team;
    }

    private static void addToVanishTeam(MinecraftServer server, PlayerTeam vanishTeam, ServerPlayer player) {
        UUID uuid = player.getUUID();
        if (TEAM_STATES.containsKey(uuid)) {
            return;
        }
        ServerScoreboard scoreboard = server.getScoreboard();
        String scoreboardName = player.getScoreboardName();
        PlayerTeam current = scoreboard.getPlayersTeam(scoreboardName);
        String previousTeam = null;
        if (current != null && !current.getName().equals(VANISH_TEAM_NAME)) {
            previousTeam = current.getName();
        }
        TEAM_STATES.put(uuid, new TeamState(previousTeam, scoreboardName));
        scoreboard.addPlayerToTeam(scoreboardName, vanishTeam);
    }

    private static void restoreTeam(MinecraftServer server, UUID uuid) {
        PlayerTeam vanishTeam;
        PlayerTeam previous;
        TeamState state = TEAM_STATES.remove(uuid);
        if (state == null) {
            return;
        }
        ServerScoreboard scoreboard = server.getScoreboard();
        scoreboard.removePlayerFromTeam(state.scoreboardName());
        if (state.previousTeam() != null && (previous = scoreboard.getPlayerTeam(state.previousTeam())) != null) {
            scoreboard.addPlayerToTeam(state.scoreboardName(), previous);
        }
        if ((vanishTeam = scoreboard.getPlayerTeam(VANISH_TEAM_NAME)) != null && vanishTeam.getPlayers().isEmpty()) {
            scoreboard.removePlayerTeam(vanishTeam);
        }
    }

    private static void clearTeam(MinecraftServer server) {
        if (TEAM_STATES.isEmpty()) {
            PlayerTeam vanishTeam = server.getScoreboard().getPlayerTeam(VANISH_TEAM_NAME);
            if (vanishTeam != null && vanishTeam.getPlayers().isEmpty()) {
                server.getScoreboard().removePlayerTeam(vanishTeam);
            }
            return;
        }
        for (UUID uuid : List.copyOf(TEAM_STATES.keySet())) {
            VanishManager.restoreTeam(server, uuid);
        }
    }

    private static boolean hasOnlineVanished(MinecraftServer server) {
        for (UUID uuid : VANISHED_PLAYERS) {
            if (server.getPlayerList().getPlayer(uuid) == null) continue;
            return true;
        }
        return false;
    }

    private static MinecraftServer getServer(ServerPlayer player) {
        if (player == null) {
            return null;
        }
        return player.level().getServer();
    }

    private static ServerEntity createServerEntity(final ServerPlayer player) {
        ServerLevel level = player.level();
        final ServerChunkCache chunkCache = level.getChunkSource();
        return new ServerEntity(level, (Entity)player, player.getType().updateInterval(), player.getType().trackDeltas(), new ServerEntity.Synchronizer(){

            public void sendToTrackingPlayers(Packet<? super ClientGamePacketListener> packet) {
                chunkCache.sendToTrackingPlayers((Entity)player, packet);
            }

            public void sendToTrackingPlayersAndSelf(Packet<? super ClientGamePacketListener> packet) {
                chunkCache.sendToTrackingPlayersAndSelf((Entity)player, packet);
            }

            public void sendToTrackingPlayersFiltered(Packet<? super ClientGamePacketListener> packet, Predicate<ServerPlayer> predicate) {
                chunkCache.chunkMap.sendToTrackingPlayersFiltered((Entity)player, packet, predicate);
            }
        });
    }

    private record TeamState(String previousTeam, String scoreboardName) {
    }
}

