/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.mixin;

import com.foundryx.command.admin.JailRestrictions;
import com.mojang.brigadier.ParseResults;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Commands.class})
public abstract class MixinCommands {
    @Inject(method={"performCommand(Lcom/mojang/brigadier/ParseResults;Ljava/lang/String;)I"}, at={@At(value="HEAD")}, cancellable=true)
    private void foundryx$preventJailedExecution(ParseResults<CommandSourceStack> parseResults, String command, CallbackInfoReturnable<Integer> cir) {
        if (this.foundryx$blockJailedSource((CommandSourceStack)parseResults.getContext().getSource())) {
            cir.setReturnValue((Object)0);
            cir.cancel();
        }
    }

    @Inject(method={"performPrefixedCommand"}, at={@At(value="HEAD")}, cancellable=true)
    private void foundryx$preventJailedPrefixed(CommandSourceStack source, String command, CallbackInfoReturnable<Integer> cir) {
        if (this.foundryx$blockJailedSource(source)) {
            cir.setReturnValue((Object)0);
            cir.cancel();
        }
    }

    private boolean foundryx$blockJailedSource(CommandSourceStack source) {
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            return JailRestrictions.denyIfJailed(serverPlayer);
        }
        return false;
    }
}

