/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.mixin;

import com.foundryx.chat.ChatFormatter;
import com.foundryx.command.admin.JailHooks;
import com.foundryx.managers.TabManager;
import java.net.SocketAddress;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.UserBanList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerList.class})
public class MixinPlayerList {
    @Inject(method={"broadcastChatMessage"}, at={@At(value="HEAD")}, cancellable=true)
    private void foundryx$formatChat(PlayerChatMessage message, CommandSourceStack source, ChatType.Bound chatType, CallbackInfo ci) {
        if (ChatFormatter.isPlatformHandlingBroadcast()) {
            return;
        }
        PlayerList playerList = (PlayerList)this;
        if (ChatFormatter.handle(playerList, message, source, chatType)) {
            ci.cancel();
        }
    }

    @Inject(method={"canPlayerLogin"}, at={@At(value="HEAD")}, cancellable=true)
    private void foundryx$handleMissingBanEntry(SocketAddress socketAddress, NameAndId profile, CallbackInfoReturnable<Component> cir) {
        PlayerList playerList = (PlayerList)this;
        UserBanList banList = playerList.getBans();
        if (banList.isBanned(profile) && banList.get((Object)profile) == null) {
            cir.setReturnValue((Object)Component.translatable((String)"multiplayer.disconnect.banned"));
            cir.cancel();
        }
    }

    @Inject(method={"remove"}, at={@At(value="TAIL")})
    private void foundryx$cleanupTabState(ServerPlayer player, CallbackInfo ci) {
        TabManager.handlePlayerQuit(player);
    }

    @Inject(method={"placeNewPlayer"}, at={@At(value="TAIL")})
    private void foundryx$enforceJail(Connection connection, ServerPlayer player, CommonListenerCookie cookie, CallbackInfo ci) {
        JailHooks.handlePlayerJoin(player);
    }
}

