/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.permission;

import com.foundryx.permission.FoundryxPermission;
import com.foundryx.permission.PermissionHandlers;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public final class FoundryxPermissions {
    private FoundryxPermissions() {
    }

    public static boolean check(CommandSourceStack source, FoundryxPermission permission) {
        return FoundryxPermissions.check(source, permission.node(), permission.fallbackLevel(), permission.allowFallbackWithLuckPerms());
    }

    public static boolean check(ServerPlayer player, FoundryxPermission permission) {
        return FoundryxPermissions.check(player, permission.node(), permission.fallbackLevel(), permission.allowFallbackWithLuckPerms());
    }

    public static boolean check(CommandSourceStack source, String permission, int fallbackLevel) {
        return FoundryxPermissions.check(source, permission, fallbackLevel, true);
    }

    public static boolean check(CommandSourceStack source, String permission, int fallbackLevel, boolean allowFallbackWithLuckPerms) {
        boolean fallback = fallbackLevel >= 0 && source.hasPermission(fallbackLevel);
        boolean allowFallback = allowFallbackWithLuckPerms || fallbackLevel == 0;
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (PermissionHandlers.isLuckPermsActive()) {
                if (PermissionHandlers.get().hasPermission(player, permission)) {
                    return true;
                }
                return allowFallback && fallback;
            }
            return fallback;
        }
        return fallback;
    }

    public static boolean check(ServerPlayer player, String permission, int fallbackLevel) {
        return FoundryxPermissions.check(player, permission, fallbackLevel, true);
    }

    public static boolean check(ServerPlayer player, String permission, int fallbackLevel, boolean allowFallbackWithLuckPerms) {
        boolean allowFallback;
        boolean fallback = fallbackLevel >= 0 && player.hasPermissions(fallbackLevel);
        boolean bl = allowFallback = allowFallbackWithLuckPerms || fallbackLevel == 0;
        if (PermissionHandlers.isLuckPermsActive()) {
            if (PermissionHandlers.get().hasPermission(player, permission)) {
                return true;
            }
            return allowFallback && fallback;
        }
        return fallback;
    }
}

