/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.permission;

import com.foundryx.permission.PermissionHandlers;
import java.lang.reflect.Method;
import net.minecraft.server.level.ServerPlayer;

public final class LuckPermsMetaUtil {
    private static final String PROVIDER_CLASS = "net.luckperms.api.LuckPermsProvider";
    private static final String PLAYER_ADAPTER_CLASS = "net.luckperms.api.platform.PlayerAdapter";
    private static final String META_DATA_CLASS = "net.luckperms.api.cacheddata.CachedMetaData";
    private static final String USER_CLASS = "net.luckperms.api.model.user.User";
    private static volatile Object adapter;
    private static volatile Method getMetaDataMethod;
    private static volatile Method getUserMethod;
    private static volatile Method getPrefixMethod;
    private static volatile Method getSuffixMethod;
    private static volatile Method getMetaValueMethod;
    private static volatile Method getPrimaryGroupMethod;
    private static volatile boolean classesMissing;

    private LuckPermsMetaUtil() {
    }

    public static String getPrefix(ServerPlayer player) {
        Object meta = LuckPermsMetaUtil.getMeta(player);
        if (meta == null || getPrefixMethod == null) {
            return null;
        }
        try {
            Object value = getPrefixMethod.invoke(meta, new Object[0]);
            return value instanceof String ? (String)value : null;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    public static String getSuffix(ServerPlayer player) {
        Object meta = LuckPermsMetaUtil.getMeta(player);
        if (meta == null || getSuffixMethod == null) {
            return null;
        }
        try {
            Object value = getSuffixMethod.invoke(meta, new Object[0]);
            return value instanceof String ? (String)value : null;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    public static int getWeight(ServerPlayer player) {
        Object meta = LuckPermsMetaUtil.getMeta(player);
        if (meta == null) {
            return 0;
        }
        return LuckPermsMetaUtil.extractWeight(meta);
    }

    public static String getPrimaryGroup(ServerPlayer player) {
        if (!LuckPermsMetaUtil.ensureAdapter()) {
            return null;
        }
        if (getUserMethod == null || getPrimaryGroupMethod == null) {
            return null;
        }
        try {
            Object user = getUserMethod.invoke(adapter, player);
            if (user == null) {
                return null;
            }
            Object primaryGroup = getPrimaryGroupMethod.invoke(user, new Object[0]);
            return primaryGroup instanceof String ? (String)primaryGroup : null;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static int extractWeight(Object metaData) {
        if (getMetaValueMethod == null) {
            return 0;
        }
        try {
            String stringValue;
            Object value = getMetaValueMethod.invoke(metaData, "weight");
            if (!(value instanceof String) || (stringValue = (String)value).isBlank()) {
                return 0;
            }
            try {
                return Integer.parseInt(stringValue);
            }
            catch (NumberFormatException ignored) {
                return 0;
            }
        }
        catch (Throwable ignored) {
            return 0;
        }
    }

    private static Object getMeta(ServerPlayer player) {
        if (!LuckPermsMetaUtil.ensureAdapter()) {
            return null;
        }
        if (getMetaDataMethod == null) {
            return null;
        }
        try {
            return getMetaDataMethod.invoke(adapter, player);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean ensureAdapter() {
        if (classesMissing || !PermissionHandlers.isLuckPermsActive()) {
            return false;
        }
        if (adapter != null && getMetaDataMethod != null) {
            return true;
        }
        Class<LuckPermsMetaUtil> clazz = LuckPermsMetaUtil.class;
        synchronized (LuckPermsMetaUtil.class) {
            if (adapter != null && getMetaDataMethod != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return true;
            }
            try {
                ClassLoader classLoader = LuckPermsMetaUtil.class.getClassLoader();
                Class<?> providerClass = Class.forName(PROVIDER_CLASS, false, classLoader);
                Class<?> playerAdapterClass = Class.forName(PLAYER_ADAPTER_CLASS, false, classLoader);
                Class<?> metaDataClass = Class.forName(META_DATA_CLASS, false, classLoader);
                Class<?> userClass = Class.forName(USER_CLASS, false, classLoader);
                Object provider = providerClass.getMethod("get", new Class[0]).invoke(null, new Object[0]);
                Object resolvedAdapter = providerClass.getMethod("getPlayerAdapter", Class.class).invoke(provider, ServerPlayer.class);
                Method metaDataMethod = playerAdapterClass.getMethod("getMetaData", ServerPlayer.class);
                Method userMethod = playerAdapterClass.getMethod("getUser", ServerPlayer.class);
                Method prefixMethod = metaDataClass.getMethod("getPrefix", new Class[0]);
                Method suffixMethod = metaDataClass.getMethod("getSuffix", new Class[0]);
                Method metaValueMethod = metaDataClass.getMethod("getMetaValue", String.class);
                Method primaryGroup = userClass.getMethod("getPrimaryGroup", new Class[0]);
                adapter = resolvedAdapter;
                getMetaDataMethod = metaDataMethod;
                getUserMethod = userMethod;
                getPrefixMethod = prefixMethod;
                getSuffixMethod = suffixMethod;
                getMetaValueMethod = metaValueMethod;
                getPrimaryGroupMethod = primaryGroup;
            }
            catch (ClassNotFoundException classNotFoundException) {
                classesMissing = true;
                LuckPermsMetaUtil.clearReflection();
            }
            catch (Throwable throwable) {
                LuckPermsMetaUtil.clearReflection();
            }
            return adapter != null && getMetaDataMethod != null;
        }
    }

    private static void clearReflection() {
        adapter = null;
        getMetaDataMethod = null;
        getUserMethod = null;
        getPrefixMethod = null;
        getSuffixMethod = null;
        getMetaValueMethod = null;
        getPrimaryGroupMethod = null;
    }
}

