/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.permission;

import com.foundryx.Constants;
import com.foundryx.permission.PermissionHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.cacheddata.CachedPermissionData;
import net.luckperms.api.platform.PlayerAdapter;
import net.luckperms.api.util.Tristate;
import net.minecraft.server.level.ServerPlayer;

final class LuckPermsPermissionHandler
implements PermissionHandler {
    private final AtomicReference<PlayerAdapter<ServerPlayer>> adapter = new AtomicReference();
    private final AtomicBoolean warnedNotLoaded = new AtomicBoolean();

    private LuckPermsPermissionHandler() {
    }

    static PermissionHandler create() {
        return new LuckPermsPermissionHandler();
    }

    private PlayerAdapter<ServerPlayer> resolveAdapter() {
        PlayerAdapter<ServerPlayer> current = this.adapter.get();
        if (current != null) {
            return current;
        }
        LuckPerms luckPerms = LuckPermsProvider.get();
        PlayerAdapter created = luckPerms.getPlayerAdapter(ServerPlayer.class);
        if (this.adapter.compareAndSet(null, (PlayerAdapter<ServerPlayer>)created)) {
            return created;
        }
        return this.adapter.get();
    }

    @Override
    public boolean hasPermission(ServerPlayer player, String permission) {
        try {
            CachedPermissionData data = this.resolveAdapter().getPermissionData((Object)player);
            Tristate result = data.checkPermission(permission);
            return result.asBoolean();
        }
        catch (IllegalStateException notLoaded) {
            if (this.warnedNotLoaded.compareAndSet(false, true)) {
                Constants.LOG.warn("LuckPerms API requested before it finished loading; Foundryx will retry on the next permission check.");
            }
            return false;
        }
    }
}

