/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.permission;

import com.foundryx.Constants;
import com.foundryx.permission.LuckPermsPermissionHandler;
import com.foundryx.permission.PermissionHandler;
import com.foundryx.platform.Services;

public final class PermissionHandlers {
    private static PermissionHandler handler = (player, permission) -> false;
    private static boolean luckPermsActive;

    private PermissionHandlers() {
    }

    public static void bootstrap() {
        handler = PermissionHandlers.discoverHandler();
    }

    public static PermissionHandler get() {
        return handler;
    }

    public static boolean isLuckPermsActive() {
        return luckPermsActive;
    }

    private static PermissionHandler discoverHandler() {
        if (Services.PLATFORM.isModLoaded("luckperms")) {
            try {
                PermissionHandler luckPermsHandler = LuckPermsPermissionHandler.create();
                luckPermsActive = true;
                Constants.LOG.info("LuckPerms detected - Foundryx permissions will be provided by the server configuration.");
                return luckPermsHandler;
            }
            catch (Throwable throwable) {
                luckPermsActive = false;
                Constants.LOG.error("Unable to initialise LuckPerms integration, falling back to vanilla permission levels.", throwable);
            }
        } else {
            luckPermsActive = false;
            Constants.LOG.info("LuckPerms not present - defaulting to vanilla operator levels for Foundryx commands.");
        }
        return (player, permission) -> false;
    }
}

