/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.platform;

import com.mojang.authlib.GameProfile;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameType;

public final class TabDisplayUpdater {
    private static final Field ENTRIES_FIELD;
    private static final Constructor<?> ENTRY_CONSTRUCTOR;
    private static final Method ENTRY_PROFILE_ID;
    private static final Method ENTRY_PROFILE;
    private static final Method ENTRY_LISTED;
    private static final Method ENTRY_LATENCY;
    private static final Method ENTRY_GAME_MODE;
    private static final Method ENTRY_SHOW_HAT;
    private static final Method ENTRY_LIST_ORDER;
    private static final Method ENTRY_CHAT_SESSION;

    private TabDisplayUpdater() {
    }

    public static boolean sendTabDisplayUpdate(ServerPlayer player, Component display) {
        ClientboundPlayerInfoUpdatePacket packet = new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME, player);
        try {
            List entries = (List)ENTRIES_FIELD.get(packet);
            if (entries.isEmpty()) {
                return false;
            }
            Object entry = entries.get(0);
            Object replacement = ENTRY_CONSTRUCTOR.newInstance(ENTRY_PROFILE_ID.invoke(entry, new Object[0]), ENTRY_PROFILE.invoke(entry, new Object[0]), ENTRY_LISTED.invoke(entry, new Object[0]), ENTRY_LATENCY.invoke(entry, new Object[0]), ENTRY_GAME_MODE.invoke(entry, new Object[0]), display, ENTRY_SHOW_HAT.invoke(entry, new Object[0]), ENTRY_LIST_ORDER.invoke(entry, new Object[0]), ENTRY_CHAT_SESSION.invoke(entry, new Object[0]));
            ENTRIES_FIELD.set(packet, List.of(replacement));
        }
        catch (ReflectiveOperationException exception) {
            ReflectiveOperationException cause = exception instanceof InvocationTargetException ? ((InvocationTargetException)exception).getCause() : exception;
            throw new IllegalStateException("Failed to update tab list display", cause != null ? cause : exception);
        }
        ServerLevel serverLevel = player.level();
        if (serverLevel instanceof ServerLevel) {
            ServerLevel level = serverLevel;
            level.getServer().getPlayerList().broadcastAll((Packet)packet);
            return true;
        }
        return false;
    }

    static {
        try {
            ENTRIES_FIELD = ClientboundPlayerInfoUpdatePacket.class.getDeclaredField("entries");
            ENTRIES_FIELD.setAccessible(true);
            Class<?> entryClass = Class.forName("net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket$Entry");
            ENTRY_CONSTRUCTOR = entryClass.getDeclaredConstructor(UUID.class, GameProfile.class, Boolean.TYPE, Integer.TYPE, GameType.class, Component.class, Boolean.TYPE, Integer.TYPE, RemoteChatSession.Data.class);
            ENTRY_CONSTRUCTOR.setAccessible(true);
            ENTRY_PROFILE_ID = entryClass.getMethod("profileId", new Class[0]);
            ENTRY_PROFILE = entryClass.getMethod("profile", new Class[0]);
            ENTRY_LISTED = entryClass.getMethod("listed", new Class[0]);
            ENTRY_LATENCY = entryClass.getMethod("latency", new Class[0]);
            ENTRY_GAME_MODE = entryClass.getMethod("gameMode", new Class[0]);
            ENTRY_SHOW_HAT = entryClass.getMethod("showHat", new Class[0]);
            ENTRY_LIST_ORDER = entryClass.getMethod("listOrder", new Class[0]);
            ENTRY_CHAT_SESSION = entryClass.getMethod("chatSession", new Class[0]);
        }
        catch (ReflectiveOperationException exception) {
            throw new IllegalStateException("Failed to prepare tab list reflection", exception);
        }
    }
}

