/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.storage;

import com.foundryx.storage.FoundryxDataStorage;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

final class UserData {
    FoundryxDataStorage.JailRecord jailRecord;
    Long muteExpiry;
    final Map<String, Long> kitUsage = new HashMap<String, Long>();
    boolean godMode;
    boolean frozen;
    String nickname;
    String lastKnownName;
    Double lastHealth;
    Integer foodLevel;
    Float saturation;
    Boolean operator;
    Boolean canFly;
    Integer gameMode;
    String lastIp;
    Long lastLogin;
    Long lastSeen;
    Long playTime;
    String muteReason;
    double balance;

    UserData() {
    }

    boolean isEmpty() {
        return !(this.jailRecord != null || this.muteExpiry != null || this.muteReason != null && !this.muteReason.isBlank() || !this.kitUsage.isEmpty() || this.godMode || this.frozen || this.nickname != null || this.lastKnownName != null || this.lastHealth != null || this.foodLevel != null || this.saturation != null || this.operator != null || this.canFly != null || this.gameMode != null || this.lastIp != null || this.lastLogin != null || this.lastSeen != null || this.playTime != null && this.playTime > 0L || !UserData.isZero(this.balance));
    }

    boolean hasWhoisInfo() {
        return this.lastKnownName != null || this.lastHealth != null || this.foodLevel != null || this.saturation != null || this.operator != null || this.canFly != null || this.gameMode != null || this.lastIp != null || this.lastLogin != null || this.lastSeen != null || this.playTime != null && this.playTime > 0L;
    }

    boolean matchesName(String normalized) {
        if (normalized == null || this.lastKnownName == null) {
            return false;
        }
        return this.lastKnownName.toLowerCase(Locale.ROOT).equals(normalized);
    }

    static boolean isZero(double value) {
        return Math.abs(value) < 1.0E-6;
    }
}

