/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.storage;

import com.foundryx.Constants;
import com.foundryx.data.PlayerWhoisData;
import com.foundryx.storage.FoundryxDataStorage;
import com.foundryx.storage.MailDataManager;
import com.foundryx.storage.UserData;
import com.foundryx.storage.database.DatabaseContext;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameType;

final class UserDataManager {
    private final Path directory;
    private final MailDataManager mailDataManager;
    private final Gson gson;
    private final Map<UUID, UserData> cache = new HashMap<UUID, UserData>();
    private final Map<UUID, Long> activeSessions = new HashMap<UUID, Long>();
    private final boolean useDatabase;
    private final DatabaseContext database;

    UserDataManager(Path directory, MailDataManager mailDataManager, Gson gson) {
        this(directory, mailDataManager, gson, null);
    }

    UserDataManager(Path directory, MailDataManager mailDataManager, Gson gson, DatabaseContext database) {
        this.directory = directory;
        this.mailDataManager = mailDataManager;
        this.gson = gson;
        this.database = database;
        this.useDatabase = database != null && database.isAvailable();
    }

    private boolean isZero(double value) {
        return Math.abs(value) < 1.0E-6;
    }

    boolean isJailed(UUID player) {
        return this.load((UUID)player).jailRecord != null;
    }

    void jailPlayer(UUID player, FoundryxDataStorage.LocationSnapshot originalLocation, FoundryxDataStorage.LocationSnapshot jailLocation, Long releaseAtMillis) {
        UserData data = this.load(player);
        data.jailRecord = new FoundryxDataStorage.JailRecord(originalLocation, jailLocation, releaseAtMillis);
        this.save(player, data);
    }

    Optional<FoundryxDataStorage.JailRecord> unjailPlayer(UUID player) {
        UserData data = this.load(player);
        FoundryxDataStorage.JailRecord record = data.jailRecord;
        data.jailRecord = null;
        this.save(player, data);
        return Optional.ofNullable(record);
    }

    Optional<FoundryxDataStorage.JailRecord> getJailRecord(UUID player) {
        return Optional.ofNullable(this.load((UUID)player).jailRecord);
    }

    Optional<FoundryxDataStorage.LocationSnapshot> getJailLocation(UUID player) {
        FoundryxDataStorage.JailRecord record = this.load((UUID)player).jailRecord;
        return record == null ? Optional.empty() : Optional.ofNullable(record.jailLocation());
    }

    void setFrozen(UUID player, boolean frozen) {
        UserData data = this.load(player);
        if (data.frozen != frozen) {
            data.frozen = frozen;
            this.save(player, data);
        }
    }

    boolean isFrozen(UUID player) {
        return this.load((UUID)player).frozen;
    }

    void setGodMode(UUID player, boolean enabled) {
        UserData data = this.load(player);
        if (data.godMode != enabled) {
            data.godMode = enabled;
            this.save(player, data);
        }
    }

    boolean hasGodMode(UUID player) {
        return this.load((UUID)player).godMode;
    }

    void mutePlayer(UUID player, long expiresAtMillis, String reason) {
        UserData data = this.load(player);
        data.muteExpiry = expiresAtMillis;
        data.muteReason = reason == null || reason.isBlank() ? null : reason;
        this.save(player, data);
    }

    void unmutePlayer(UUID player) {
        UserData data = this.load(player);
        if (data.muteExpiry != null) {
            data.muteExpiry = null;
            data.muteReason = null;
            this.save(player, data);
        }
    }

    Optional<Long> getMuteExpiry(UUID player) {
        UserData data = this.load(player);
        Long expiry = data.muteExpiry;
        if (expiry == null) {
            return Optional.empty();
        }
        if (expiry > 0L && expiry < System.currentTimeMillis()) {
            data.muteExpiry = null;
            data.muteReason = null;
            this.save(player, data);
            return Optional.empty();
        }
        return Optional.of(expiry);
    }

    Optional<String> getMuteReason(UUID player) {
        String reason = this.load((UUID)player).muteReason;
        if (reason == null || reason.isBlank()) {
            return Optional.empty();
        }
        return Optional.of(reason);
    }

    boolean isMuted(UUID player) {
        return this.getMuteExpiry(player).isPresent();
    }

    Optional<String> getNickname(UUID player) {
        String nickname = this.load((UUID)player).nickname;
        if (nickname == null || nickname.isBlank()) {
            return Optional.empty();
        }
        return Optional.of(nickname);
    }

    void setNickname(UUID player, String nickname) {
        UserData data = this.load(player);
        String normalised = this.normalizeNickname(nickname);
        if (normalised == null) {
            if (data.nickname != null) {
                data.nickname = null;
                this.save(player, data);
            }
            return;
        }
        if (!normalised.equals(data.nickname)) {
            data.nickname = normalised;
            this.save(player, data);
        }
    }

    void updateWhoisSnapshot(ServerPlayer player) {
        if (player == null) {
            return;
        }
        UUID uuid = player.getUUID();
        UserData data = this.load(uuid);
        data.lastKnownName = player.getScoreboardName();
        data.lastHealth = player.getHealth();
        data.foodLevel = player.getFoodData().getFoodLevel();
        data.saturation = Float.valueOf(player.getFoodData().getSaturationLevel());
        GameType gameType = player.gameMode.getGameModeForPlayer();
        data.gameMode = gameType == null ? null : Integer.valueOf(gameType.getId());
        data.operator = player.hasPermissions(2);
        data.canFly = player.getAbilities().mayfly;
        String ipAddress = player.getIpAddress();
        data.lastIp = ipAddress == null || ipAddress.isBlank() ? null : ipAddress;
        this.save(uuid, data);
    }

    void recordLogin(ServerPlayer player) {
        if (player == null) {
            return;
        }
        UUID uuid = player.getUUID();
        UserData data = this.load(uuid);
        long now = System.currentTimeMillis();
        this.activeSessions.put(uuid, now);
        data.lastLogin = now;
        data.lastKnownName = player.getScoreboardName();
        if (data.playTime == null) {
            data.playTime = 0L;
        }
        this.save(uuid, data);
    }

    void recordLogout(ServerPlayer player) {
        if (player == null) {
            return;
        }
        UUID uuid = player.getUUID();
        UserData data = this.load(uuid);
        long now = System.currentTimeMillis();
        Long sessionStart = this.activeSessions.remove(uuid);
        if (sessionStart != null) {
            long additional = Math.max(0L, now - sessionStart);
            if (data.playTime == null) {
                data.playTime = additional;
            } else {
                long updated;
                try {
                    updated = Math.addExact(data.playTime, additional);
                }
                catch (ArithmeticException exception) {
                    updated = Long.MAX_VALUE;
                }
                data.playTime = updated;
            }
        }
        data.lastSeen = now;
        this.save(uuid, data);
    }

    Optional<PlayerWhoisData> getWhoisData(UUID player) {
        String lastIp;
        UserData data = this.load(player);
        boolean hasSession = this.activeSessions.containsKey(player);
        if (!data.hasWhoisInfo() && !hasSession) {
            return Optional.empty();
        }
        long total = data.playTime == null ? 0L : data.playTime;
        Long sessionStart = this.activeSessions.get(player);
        if (sessionStart != null) {
            long additional = Math.max(0L, System.currentTimeMillis() - sessionStart);
            try {
                total = Math.addExact(total, additional);
            }
            catch (ArithmeticException exception) {
                total = Long.MAX_VALUE;
            }
        }
        if ((lastIp = data.lastIp) != null && lastIp.isBlank()) {
            lastIp = null;
        }
        return Optional.of(new PlayerWhoisData(player, data.lastKnownName, data.lastHealth, data.foodLevel, data.saturation, data.gameMode, data.operator, data.canFly, lastIp, data.lastLogin, data.lastSeen, total));
    }

    Optional<UUID> findUuidByName(String name) {
        Optional<UUID> optional;
        block12: {
            if (name == null || name.isBlank()) {
                return Optional.empty();
            }
            String normalized = name.toLowerCase(Locale.ROOT);
            for (Map.Entry<UUID, UserData> entry : this.cache.entrySet()) {
                if (!entry.getValue().matchesName(normalized)) continue;
                return Optional.of(entry.getKey());
            }
            if (this.useDatabase) {
                return this.findUuidByNameDatabase(normalized);
            }
            if (!Files.isDirectory(this.directory, new LinkOption[0])) {
                return Optional.empty();
            }
            Stream<Path> files = Files.list(this.directory);
            try {
                optional = files.filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().endsWith(".json")).map(Path::getFileName).map(Path::toString).map(namePart -> namePart.substring(0, namePart.length() - 5)).map(candidate -> {
                    try {
                        return UUID.fromString(candidate);
                    }
                    catch (IllegalArgumentException exception) {
                        return null;
                    }
                }).filter(Objects::nonNull).map(uuid -> {
                    UserData data = this.load((UUID)uuid);
                    return data.matchesName(normalized) ? uuid : null;
                }).filter(Objects::nonNull).findFirst();
                if (files == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    Constants.LOG.error("Failed to resolve stored player data for '{}'.", (Object)name, (Object)exception);
                    return Optional.empty();
                }
            }
            files.close();
        }
        return optional;
    }

    /*
     * Exception decompiling
     */
    private Optional<UUID> findUuidByNameDatabase(String normalized) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    long getRemainingKitCooldown(UUID player, String kitName, long cooldownSeconds) {
        long expiry;
        long cooldownMillis;
        if (kitName == null || cooldownSeconds <= 0L) {
            return 0L;
        }
        UserData data = this.load(player);
        String key = this.normalise(kitName);
        Long lastUsed = data.kitUsage.get(key);
        if (lastUsed == null) {
            return 0L;
        }
        try {
            cooldownMillis = Math.multiplyExact(cooldownSeconds, 1000L);
        }
        catch (ArithmeticException exception) {
            cooldownMillis = Long.MAX_VALUE;
        }
        try {
            expiry = Math.addExact(lastUsed, cooldownMillis);
        }
        catch (ArithmeticException exception) {
            expiry = Long.MAX_VALUE;
        }
        long now = System.currentTimeMillis();
        long remainingMillis = expiry - now;
        if (remainingMillis <= 0L) {
            data.kitUsage.remove(key);
            this.save(player, data);
            return 0L;
        }
        long seconds = remainingMillis / 1000L;
        if (remainingMillis % 1000L != 0L) {
            ++seconds;
        }
        return Math.max(0L, seconds);
    }

    void recordKitUsage(UUID player, String kitName, long usedAtMillis) {
        if (kitName == null) {
            return;
        }
        UserData data = this.load(player);
        data.kitUsage.put(this.normalise(kitName), usedAtMillis);
        this.save(player, data);
    }

    void clearKitUsage(String kitName) {
        if (kitName == null) {
            return;
        }
        String key = this.normalise(kitName);
        if (this.useDatabase) {
            try (Connection connection = this.database.getConnection();
                 PreparedStatement statement = connection.prepareStatement("DELETE FROM foundryx_kit_usage WHERE kit_name=?");){
                statement.setString(1, key);
                statement.executeUpdate();
            }
            catch (SQLException exception) {
                Constants.LOG.error("Failed to clear kit usage for '{}'", (Object)kitName, (Object)exception);
            }
        }
        for (Map.Entry<UUID, UserData> entry : this.cache.entrySet()) {
            UserData data = entry.getValue();
            if (data.kitUsage.remove(key) == null || this.useDatabase) continue;
            this.save(entry.getKey(), data);
        }
    }

    double getBalance(UUID player) {
        return this.load((UUID)player).balance;
    }

    void setBalance(UUID player, double amount) {
        double clamped = Math.max(0.0, amount);
        UserData data = this.load(player);
        if (Double.compare(data.balance, clamped) != 0) {
            data.balance = clamped;
            this.save(player, data);
        }
    }

    void addBalance(UUID player, double amount) {
        if (amount <= 0.0) {
            return;
        }
        UserData data = this.load(player);
        data.balance = Math.max(0.0, data.balance + amount);
        this.save(player, data);
    }

    boolean removeBalance(UUID player, double amount) {
        if (amount <= 0.0) {
            return true;
        }
        UserData data = this.load(player);
        if (Double.compare(data.balance, amount) < 0) {
            return false;
        }
        data.balance = Math.max(0.0, data.balance - amount);
        this.save(player, data);
        return true;
    }

    private UserData load(UUID player) {
        if (this.useDatabase) {
            return this.cache.computeIfAbsent(player, this::readUserDataFromDatabase);
        }
        return this.cache.computeIfAbsent(player, this::readUserDataFromFile);
    }

    private UserData readUserDataFromFile(UUID player) {
        Path file = this.filePath(player);
        UserData data = new UserData();
        if (!Files.exists(file, new LinkOption[0])) {
            return data;
        }
        try (BufferedReader reader = Files.newBufferedReader(file);){
            PersistedUserData persisted = (PersistedUserData)this.gson.fromJson((Reader)reader, PersistedUserData.class);
            if (persisted != null) {
                data.jailRecord = persisted.jail();
                data.muteExpiry = persisted.muteExpiry();
                if (persisted.kitUsage() != null) {
                    persisted.kitUsage().forEach((kit, timestamp) -> {
                        if (kit != null && timestamp != null) {
                            data.kitUsage.put(this.normalise((String)kit), (Long)timestamp);
                        }
                    });
                }
                data.godMode = persisted.godMode() != null && persisted.godMode() != false;
                data.frozen = persisted.frozen() != null && persisted.frozen() != false;
                data.nickname = this.normalizeNickname(persisted.nickname());
                data.lastKnownName = persisted.lastKnownName();
                data.lastHealth = persisted.lastHealth();
                data.foodLevel = persisted.foodLevel();
                data.saturation = persisted.saturation();
                data.operator = persisted.operator();
                data.canFly = persisted.canFly();
                data.gameMode = persisted.gameMode();
                data.lastIp = persisted.lastIp();
                if (data.lastIp != null && data.lastIp.isBlank()) {
                    data.lastIp = null;
                }
                data.lastLogin = persisted.lastLogin();
                data.lastSeen = persisted.lastSeen();
                data.playTime = persisted.playTime();
                data.muteReason = persisted.muteReason();
                if (persisted.balance() != null) {
                    data.balance = Math.max(0.0, persisted.balance());
                }
            }
        }
        catch (IOException exception) {
            Constants.LOG.error("Failed to read user data for {}", (Object)player, (Object)exception);
        }
        return data;
    }

    private void save(UUID player, UserData data) {
        Path file = this.filePath(player);
        try {
            if (this.mailDataManager != null) {
                this.mailDataManager.ensureMailMigrated(player);
            }
            if (this.useDatabase) {
                if (data == null) {
                    this.deleteUserData(player);
                    return;
                }
                this.persistUserData(player, data);
                if (data.isEmpty()) {
                    this.cache.remove(player);
                } else {
                    this.cache.put(player, data);
                }
                return;
            }
            if (data.isEmpty()) {
                this.cache.remove(player);
                Files.deleteIfExists(file);
                return;
            }
            Files.createDirectories(this.directory, new FileAttribute[0]);
            PersistedUserData persisted = new PersistedUserData(data.jailRecord, data.muteExpiry, data.kitUsage.isEmpty() ? Map.of() : Map.copyOf(data.kitUsage), data.godMode, data.frozen, data.nickname, data.lastKnownName, data.lastHealth, data.foodLevel, data.saturation, data.operator, data.canFly, data.gameMode, data.lastIp, data.lastLogin, data.lastSeen, data.playTime, data.muteReason, this.isZero(data.balance) ? null : Double.valueOf(data.balance));
            try (BufferedWriter writer = Files.newBufferedWriter(file, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
                this.gson.toJson((Object)persisted, (Appendable)writer);
            }
        }
        catch (IOException exception) {
            Constants.LOG.error("Failed to write user data for {}", (Object)player, (Object)exception);
        }
    }

    private Path filePath(UUID player) {
        return this.directory.resolve(player.toString() + ".json");
    }

    void flush() {
        if (!this.useDatabase) {
            return;
        }
        for (Map.Entry<UUID, UserData> entry : this.cache.entrySet()) {
            this.persistUserData(entry.getKey(), entry.getValue());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UserData readUserDataFromDatabase(UUID player) {
        UserData data = new UserData();
        if (player == null) {
            return data;
        }
        try (Connection connection = this.database.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT nickname, last_known_name, last_login, last_seen, play_time, god_mode, frozen, mute_expiry, mute_reason, last_ip, balance, last_health, food_level, saturation, operator, can_fly, game_mode, jail_origin_dimension, jail_origin_x, jail_origin_y, jail_origin_z, jail_origin_yaw, jail_origin_pitch, jail_location_dimension, jail_location_x, jail_location_y, jail_location_z, jail_location_yaw, jail_location_pitch, jail_release FROM foundryx_user_data WHERE player_uuid=?");){
            statement.setString(1, player.toString());
            try (ResultSet resultSet = statement.executeQuery();){
                Boolean canFly;
                Double balance;
                if (!resultSet.next()) {
                    UserData userData = data;
                    return userData;
                }
                data.nickname = this.normalizeNickname(resultSet.getString("nickname"));
                data.lastKnownName = resultSet.getString("last_known_name");
                data.lastLogin = this.getNullableLong(resultSet, "last_login");
                data.lastSeen = this.getNullableLong(resultSet, "last_seen");
                data.playTime = this.getNullableLong(resultSet, "play_time");
                data.godMode = resultSet.getBoolean("god_mode");
                data.frozen = resultSet.getBoolean("frozen");
                data.muteExpiry = this.getNullableLong(resultSet, "mute_expiry");
                data.muteReason = resultSet.getString("mute_reason");
                data.lastIp = resultSet.getString("last_ip");
                if (data.lastIp != null && data.lastIp.isBlank()) {
                    data.lastIp = null;
                }
                if ((balance = this.getNullableDouble(resultSet, "balance")) != null) {
                    data.balance = Math.max(0.0, balance);
                }
                data.lastHealth = this.getNullableDouble(resultSet, "last_health");
                data.foodLevel = this.getNullableInteger(resultSet, "food_level");
                data.saturation = this.getNullableFloat(resultSet, "saturation");
                Boolean operator = this.getNullableBoolean(resultSet, "operator");
                if (operator != null) {
                    data.operator = operator;
                }
                if ((canFly = this.getNullableBoolean(resultSet, "can_fly")) != null) {
                    data.canFly = canFly;
                }
                data.gameMode = this.getNullableInteger(resultSet, "game_mode");
                FoundryxDataStorage.LocationSnapshot origin = this.buildSnapshotFromRow(resultSet, "jail_origin");
                FoundryxDataStorage.LocationSnapshot jail = this.buildSnapshotFromRow(resultSet, "jail_location");
                Long release = this.getNullableLong(resultSet, "jail_release");
                if (origin != null || jail != null || release != null) {
                    data.jailRecord = new FoundryxDataStorage.JailRecord(origin, jail, release);
                }
                this.loadKitUsage(player, data, connection);
                return data;
            }
        }
        catch (SQLException exception) {
            Constants.LOG.error("Failed to read user data for {}", (Object)player, (Object)exception);
        }
        return data;
    }

    private void persistUserData(UUID player, UserData data) {
        if (player == null) {
            return;
        }
        if (data == null || data.isEmpty()) {
            this.deleteUserData(player);
            return;
        }
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            try {
                block27: {
                    try (PreparedStatement update = connection.prepareStatement("UPDATE foundryx_user_data SET nickname=?, last_known_name=?, last_login=?, last_seen=?, play_time=?, god_mode=?, frozen=?, mute_expiry=?, mute_reason=?, last_ip=?, balance=?, last_health=?, food_level=?, saturation=?, operator=?, can_fly=?, game_mode=?, jail_origin_dimension=?, jail_origin_x=?, jail_origin_y=?, jail_origin_z=?, jail_origin_yaw=?, jail_origin_pitch=?, jail_location_dimension=?, jail_location_x=?, jail_location_y=?, jail_location_z=?, jail_location_yaw=?, jail_location_pitch=?, jail_release=? WHERE player_uuid=?");){
                        int index = this.bindUserDataColumns(update, data, 1);
                        update.setString(index, player.toString());
                        int updated = update.executeUpdate();
                        if (updated != 0) break block27;
                        try (PreparedStatement insert = connection.prepareStatement("INSERT INTO foundryx_user_data (player_uuid, nickname, last_known_name, last_login, last_seen, play_time, god_mode, frozen, mute_expiry, mute_reason, last_ip, balance, last_health, food_level, saturation, operator, can_fly, game_mode, jail_origin_dimension, jail_origin_x, jail_origin_y, jail_origin_z, jail_origin_yaw, jail_origin_pitch, jail_location_dimension, jail_location_x, jail_location_y, jail_location_z, jail_location_yaw, jail_location_pitch, jail_release) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");){
                            insert.setString(1, player.toString());
                            this.bindUserDataColumns(insert, data, 2);
                            insert.executeUpdate();
                        }
                    }
                }
                this.writeKitUsage(connection, player, data.kitUsage);
                connection.commit();
            }
            catch (SQLException exception) {
                connection.rollback();
                throw exception;
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException exception) {
            Constants.LOG.error("Failed to persist user data for {}", (Object)player, (Object)exception);
        }
    }

    private void deleteUserData(UUID player) {
        if (player == null) {
            return;
        }
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            try {
                try (PreparedStatement deleteUsage = connection.prepareStatement("DELETE FROM foundryx_kit_usage WHERE player_uuid=?");){
                    deleteUsage.setString(1, player.toString());
                    deleteUsage.executeUpdate();
                }
                try (PreparedStatement deleteUser = connection.prepareStatement("DELETE FROM foundryx_user_data WHERE player_uuid=?");){
                    deleteUser.setString(1, player.toString());
                    deleteUser.executeUpdate();
                }
                connection.commit();
            }
            catch (SQLException exception) {
                connection.rollback();
                throw exception;
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException exception) {
            Constants.LOG.error("Failed to delete user data for {}", (Object)player, (Object)exception);
        }
        this.cache.remove(player);
    }

    private void loadKitUsage(UUID player, UserData data, Connection connection) throws SQLException {
        data.kitUsage.clear();
        try (PreparedStatement statement = connection.prepareStatement("SELECT kit_name, last_used_at FROM foundryx_kit_usage WHERE player_uuid=?");){
            statement.setString(1, player.toString());
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    String kit = resultSet.getString("kit_name");
                    Long timestamp = this.getNullableLong(resultSet, "last_used_at");
                    if (kit == null) continue;
                    data.kitUsage.put(this.normalise(kit), timestamp);
                }
            }
        }
    }

    private void writeKitUsage(Connection connection, UUID player, Map<String, Long> kitUsage) throws SQLException {
        try (PreparedStatement delete = connection.prepareStatement("DELETE FROM foundryx_kit_usage WHERE player_uuid=?");){
            delete.setString(1, player.toString());
            delete.executeUpdate();
        }
        if (kitUsage.isEmpty()) {
            return;
        }
        try (PreparedStatement insert = connection.prepareStatement("INSERT INTO foundryx_kit_usage (player_uuid, kit_name, last_used_at) VALUES (?,?,?)");){
            for (Map.Entry<String, Long> entry : kitUsage.entrySet()) {
                insert.setString(1, player.toString());
                insert.setString(2, this.normalise(entry.getKey()));
                Long timestamp = entry.getValue();
                if (timestamp == null) {
                    insert.setNull(3, -5);
                } else {
                    insert.setLong(3, timestamp);
                }
                insert.addBatch();
            }
            insert.executeBatch();
        }
    }

    private int bindUserDataColumns(PreparedStatement statement, UserData data, int index) throws SQLException {
        this.setNullableString(statement, index++, data.nickname);
        this.setNullableString(statement, index++, data.lastKnownName);
        this.setNullableLong(statement, index++, data.lastLogin);
        this.setNullableLong(statement, index++, data.lastSeen);
        this.setNullableLong(statement, index++, data.playTime);
        statement.setBoolean(index++, data.godMode);
        statement.setBoolean(index++, data.frozen);
        this.setNullableLong(statement, index++, data.muteExpiry);
        this.setNullableString(statement, index++, data.muteReason);
        this.setNullableString(statement, index++, data.lastIp);
        this.setNullableDouble(statement, index++, UserData.isZero(data.balance) ? null : Double.valueOf(data.balance));
        this.setNullableDouble(statement, index++, data.lastHealth);
        this.setNullableInteger(statement, index++, data.foodLevel);
        this.setNullableFloat(statement, index++, data.saturation);
        this.setNullableBoolean(statement, index++, data.operator);
        this.setNullableBoolean(statement, index++, data.canFly);
        this.setNullableInteger(statement, index++, data.gameMode);
        index = this.bindLocation(statement, index, data.jailRecord == null ? null : data.jailRecord.originalLocation());
        index = this.bindLocation(statement, index, data.jailRecord == null ? null : data.jailRecord.jailLocation());
        this.setNullableLong(statement, index++, data.jailRecord == null ? null : data.jailRecord.releaseAtMillis());
        return index;
    }

    private int bindLocation(PreparedStatement statement, int index, FoundryxDataStorage.LocationSnapshot snapshot) throws SQLException {
        if (snapshot == null) {
            statement.setNull(index++, 12);
            statement.setNull(index++, 8);
            statement.setNull(index++, 8);
            statement.setNull(index++, 8);
            statement.setNull(index++, 7);
            statement.setNull(index++, 7);
        } else {
            statement.setString(index++, snapshot.dimension());
            statement.setDouble(index++, snapshot.x());
            statement.setDouble(index++, snapshot.y());
            statement.setDouble(index++, snapshot.z());
            statement.setFloat(index++, snapshot.yaw());
            statement.setFloat(index++, snapshot.pitch());
        }
        return index;
    }

    private FoundryxDataStorage.LocationSnapshot buildSnapshotFromRow(ResultSet resultSet, String prefix) throws SQLException {
        String dimension = resultSet.getString(prefix + "_dimension");
        if (dimension == null) {
            return null;
        }
        double x = resultSet.getDouble(prefix + "_x");
        double y = resultSet.getDouble(prefix + "_y");
        double z = resultSet.getDouble(prefix + "_z");
        float yaw = resultSet.getFloat(prefix + "_yaw");
        float pitch = resultSet.getFloat(prefix + "_pitch");
        return new FoundryxDataStorage.LocationSnapshot(dimension, x, y, z, yaw, pitch);
    }

    private void setNullableString(PreparedStatement statement, int index, String value) throws SQLException {
        if (value == null || value.isBlank()) {
            statement.setNull(index, 12);
        } else {
            statement.setString(index, value);
        }
    }

    private void setNullableLong(PreparedStatement statement, int index, Long value) throws SQLException {
        if (value == null) {
            statement.setNull(index, -5);
        } else {
            statement.setLong(index, value);
        }
    }

    private void setNullableInteger(PreparedStatement statement, int index, Integer value) throws SQLException {
        if (value == null) {
            statement.setNull(index, 4);
        } else {
            statement.setInt(index, value);
        }
    }

    private void setNullableDouble(PreparedStatement statement, int index, Double value) throws SQLException {
        if (value == null) {
            statement.setNull(index, 8);
        } else {
            statement.setDouble(index, value);
        }
    }

    private void setNullableFloat(PreparedStatement statement, int index, Float value) throws SQLException {
        if (value == null) {
            statement.setNull(index, 7);
        } else {
            statement.setFloat(index, value.floatValue());
        }
    }

    private void setNullableBoolean(PreparedStatement statement, int index, Boolean value) throws SQLException {
        if (value == null) {
            statement.setNull(index, 16);
        } else {
            statement.setBoolean(index, value);
        }
    }

    private Long getNullableLong(ResultSet resultSet, String column) throws SQLException {
        long value = resultSet.getLong(column);
        return resultSet.wasNull() ? null : Long.valueOf(value);
    }

    private Integer getNullableInteger(ResultSet resultSet, String column) throws SQLException {
        int value = resultSet.getInt(column);
        return resultSet.wasNull() ? null : Integer.valueOf(value);
    }

    private Double getNullableDouble(ResultSet resultSet, String column) throws SQLException {
        double value = resultSet.getDouble(column);
        return resultSet.wasNull() ? null : Double.valueOf(value);
    }

    private Float getNullableFloat(ResultSet resultSet, String column) throws SQLException {
        float value = resultSet.getFloat(column);
        return resultSet.wasNull() ? null : Float.valueOf(value);
    }

    private Boolean getNullableBoolean(ResultSet resultSet, String column) throws SQLException {
        boolean value = resultSet.getBoolean(column);
        return resultSet.wasNull() ? null : Boolean.valueOf(value);
    }

    private String normalizeNickname(String nickname) {
        if (nickname == null) {
            return null;
        }
        String trimmed = nickname.trim();
        return trimmed.isEmpty() ? null : trimmed;
    }

    private String normalise(String name) {
        return name.toLowerCase(Locale.ROOT);
    }

    private record PersistedUserData(FoundryxDataStorage.JailRecord jail, Long muteExpiry, Map<String, Long> kitUsage, Boolean godMode, Boolean frozen, String nickname, String lastKnownName, Double lastHealth, Integer foodLevel, Float saturation, Boolean operator, Boolean canFly, Integer gameMode, String lastIp, Long lastLogin, Long lastSeen, Long playTime, String muteReason, Double balance) {
    }
}

