/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.teleport;

import com.foundryx.localization.Localization;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public final class TeleportDelayManager {
    private static final Map<MinecraftServer, TeleportDelayManager> INSTANCES = new ConcurrentHashMap<MinecraftServer, TeleportDelayManager>();
    private final Map<UUID, PendingTeleport> pending = new HashMap<UUID, PendingTeleport>();

    private TeleportDelayManager() {
    }

    public static TeleportDelayManager get(MinecraftServer server) {
        return INSTANCES.computeIfAbsent(server, ignored -> new TeleportDelayManager());
    }

    public void scheduleTeleport(ServerPlayer player, int delaySeconds, boolean cancelOnMove, boolean cancelOnDamage, Consumer<ServerPlayer> action, Runnable cancelCallback) {
        if (player == null) {
            return;
        }
        if (delaySeconds <= 0) {
            action.accept(player);
            return;
        }
        PendingTeleport pendingTeleport = new PendingTeleport(delaySeconds * 20, cancelOnMove, cancelOnDamage, player.getX(), player.getY(), player.getZ(), action, cancelCallback);
        PendingTeleport existing = this.pending.put(player.getUUID(), pendingTeleport);
        if (existing != null) {
            existing.cancel(null, CancelReason.REPLACED);
        }
        player.sendSystemMessage((Component)Localization.formatted("commands.foundryx.teleport.delay.start", delaySeconds));
    }

    public void tick(MinecraftServer server) {
        Iterator<Map.Entry<UUID, PendingTeleport>> iterator = this.pending.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, PendingTeleport> entry = iterator.next();
            ServerPlayer player = server.getPlayerList().getPlayer(entry.getKey());
            PendingTeleport teleport = entry.getValue();
            if (player == null) {
                iterator.remove();
                teleport.cancel(null, CancelReason.OFFLINE);
                continue;
            }
            if (!teleport.tick()) continue;
            iterator.remove();
            teleport.execute(player);
        }
    }

    public void handlePlayerTick(ServerPlayer player) {
        PendingTeleport teleport = this.pending.get(player.getUUID());
        if (teleport == null || !teleport.cancelOnMove()) {
            return;
        }
        if (teleport.hasMoved(player)) {
            this.pending.remove(player.getUUID());
            teleport.cancel(player, CancelReason.MOVEMENT);
        }
    }

    public void handlePlayerDamage(ServerPlayer player) {
        PendingTeleport teleport = this.pending.get(player.getUUID());
        if (teleport == null || !teleport.cancelOnDamage()) {
            return;
        }
        this.pending.remove(player.getUUID());
        teleport.cancel(player, CancelReason.DAMAGE);
    }

    public void handlePlayerQuit(ServerPlayer player) {
        PendingTeleport teleport = this.pending.remove(player.getUUID());
        if (teleport != null) {
            teleport.cancel(null, CancelReason.OFFLINE);
        }
    }

    private static final class PendingTeleport {
        private static final double MOVEMENT_THRESHOLD = 0.01;
        private int ticksRemaining;
        private final boolean cancelOnMove;
        private final boolean cancelOnDamage;
        private final double startX;
        private final double startY;
        private final double startZ;
        private final Consumer<ServerPlayer> action;
        private final Runnable cancelCallback;
        private boolean completed;

        private PendingTeleport(int ticksRemaining, boolean cancelOnMove, boolean cancelOnDamage, double startX, double startY, double startZ, Consumer<ServerPlayer> action, Runnable cancelCallback) {
            this.ticksRemaining = Math.max(ticksRemaining, 0);
            this.cancelOnMove = cancelOnMove;
            this.cancelOnDamage = cancelOnDamage;
            this.startX = startX;
            this.startY = startY;
            this.startZ = startZ;
            this.action = action;
            this.cancelCallback = cancelCallback;
        }

        private boolean cancelOnMove() {
            return this.cancelOnMove;
        }

        private boolean cancelOnDamage() {
            return this.cancelOnDamage;
        }

        private boolean tick() {
            if (this.completed) {
                return false;
            }
            if (this.ticksRemaining > 0) {
                --this.ticksRemaining;
            }
            return this.ticksRemaining <= 0;
        }

        private boolean hasMoved(ServerPlayer player) {
            double dz;
            double dy;
            double dx = player.getX() - this.startX;
            return dx * dx + (dy = player.getY() - this.startY) * dy + (dz = player.getZ() - this.startZ) * dz > 0.01;
        }

        private void execute(ServerPlayer player) {
            if (this.completed) {
                return;
            }
            this.completed = true;
            this.action.accept(player);
        }

        private void cancel(ServerPlayer player, CancelReason reason) {
            if (this.completed) {
                return;
            }
            this.completed = true;
            if (this.cancelCallback != null) {
                this.cancelCallback.run();
            }
            if (player == null) {
                return;
            }
            switch (reason.ordinal()) {
                case 0: {
                    player.sendSystemMessage((Component)Localization.formatted("commands.foundryx.teleport.delay.moved"));
                    break;
                }
                case 1: {
                    player.sendSystemMessage((Component)Localization.formatted("commands.foundryx.teleport.delay.damaged"));
                    break;
                }
            }
        }
    }

    private static enum CancelReason {
        MOVEMENT,
        DAMAGE,
        OFFLINE,
        REPLACED;

    }
}

