/*
 * Decompiled with CFR 0.152.
 */
package com.foundryx.teleport;

import com.foundryx.storage.FoundryxDataStorage;
import com.foundryx.teleport.TeleportService;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public final class TeleportRequestManager {
    private static final Map<MinecraftServer, TeleportRequestManager> INSTANCES = new HashMap<MinecraftServer, TeleportRequestManager>();
    private final Map<UUID, TeleportRequest> pending = new HashMap<UUID, TeleportRequest>();

    private TeleportRequestManager() {
    }

    public static TeleportRequestManager get(MinecraftServer server) {
        return INSTANCES.computeIfAbsent(server, ignored -> new TeleportRequestManager());
    }

    public void createRequest(ServerPlayer requester, ServerPlayer target, boolean here, long durationMillis) {
        this.pending.put(target.getUUID(), new TeleportRequest(requester.getUUID(), target.getUUID(), System.currentTimeMillis() + durationMillis, here));
    }

    public Optional<TeleportRequest> consumeRequest(UUID target) {
        TeleportRequest request = this.pending.remove(target);
        if (request == null) {
            return Optional.empty();
        }
        if (request.expired()) {
            return Optional.empty();
        }
        return Optional.of(request);
    }

    public Optional<TeleportRequest> peekRequest(UUID target) {
        TeleportRequest request = this.pending.get(target);
        if (request == null || request.expired()) {
            return Optional.empty();
        }
        return Optional.of(request);
    }

    public record TeleportRequest(UUID requester, UUID target, long expiresAt, boolean here) {
        public boolean expired() {
            return this.expiresAt > 0L && System.currentTimeMillis() > this.expiresAt;
        }

        public boolean teleport(MinecraftServer server, FoundryxDataStorage storage) {
            ServerPlayer requesterPlayer = server.getPlayerList().getPlayer(this.requester);
            ServerPlayer targetPlayer = server.getPlayerList().getPlayer(this.target);
            if (requesterPlayer == null || targetPlayer == null) {
                return false;
            }
            if (this.here) {
                FoundryxDataStorage.LocationSnapshot destination = FoundryxDataStorage.LocationSnapshot.from(requesterPlayer);
                return destination.toTeleportTarget().filter(point -> TeleportService.teleport(targetPlayer, point, storage)).isPresent();
            }
            FoundryxDataStorage.LocationSnapshot destination = FoundryxDataStorage.LocationSnapshot.from(targetPlayer);
            return destination.toTeleportTarget().filter(point -> TeleportService.teleport(requesterPlayer, point, storage)).isPresent();
        }
    }
}

