/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.commands.Command;
import com.wynntils.models.worlds.type.BombInfo;
import com.wynntils.models.worlds.type.BombType;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class BombBellCommand
extends Command {
    private static final SuggestionProvider<CommandSourceStack> BOMB_TYPE_SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest(Arrays.stream(BombType.values()).map(Enum::name), (SuggestionsBuilder)builder);

    @Override
    public String getCommandName() {
        return "bombbell";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> getCommandBuilder(LiteralArgumentBuilder<CommandSourceStack> base, CommandBuildContext context) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)base.then(Commands.literal((String)"list").executes(this::listBombs))).then(Commands.literal((String)"get").then(Commands.argument((String)"bombType", (ArgumentType)StringArgumentType.word()).suggests(BOMB_TYPE_SUGGESTION_PROVIDER).executes(this::getBombTypeList)))).executes(this::listBombs);
    }

    private int getBombTypeList(CommandContext<CommandSourceStack> context) {
        BombType bombType;
        try {
            bombType = BombType.valueOf((String)context.getArgument("bombType", String.class));
        }
        catch (IllegalArgumentException e) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Invalid bomb type").withStyle(ChatFormatting.RED));
            return 0;
        }
        Set<BombInfo> bombBells = Models.Bomb.getBombBells().stream().filter(bombInfo -> bombInfo.bomb() == bombType).collect(Collectors.toSet());
        MutableComponent component = BombBellCommand.getBombListComponent(bombBells);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> component, false);
        return 1;
    }

    private int listBombs(CommandContext<CommandSourceStack> context) {
        Set<BombInfo> bombBells = Models.Bomb.getBombBells();
        MutableComponent component = BombBellCommand.getBombListComponent(bombBells);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> component, false);
        return 1;
    }

    private static MutableComponent getBombListComponent(Set<BombInfo> bombBells) {
        MutableComponent response = Component.literal((String)"Bombs: ").withStyle(ChatFormatting.GOLD);
        if (bombBells.isEmpty()) {
            response.append((Component)Component.literal((String)"There are no active bombs at the moment! This might be because there are no bombs currently, or you do not have the ").withStyle(ChatFormatting.RED)).append((Component)Component.literal((String)"CHAMPION").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)" rank on Wynncraft, which is necessary to receive bomb alerts from other servers.").withStyle(ChatFormatting.RED));
            return response;
        }
        for (BombInfo bomb : bombBells.stream().sorted(Comparator.comparing(BombInfo::bomb).reversed().thenComparing(BombInfo::startTime).reversed()).toList()) {
            response.append((Component)Component.literal((String)("\n" + bomb.bomb().getDisplayName())).withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)" on ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)bomb.server()).withStyle(ChatFormatting.WHITE))).append((Component)Component.literal((String)" for: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)bomb.getRemainingString()).withStyle(ChatFormatting.WHITE)));
        }
        return response;
    }
}

