/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.commands.Command;
import com.wynntils.screens.base.WynntilsMenuScreenBase;
import com.wynntils.screens.lootrunpaths.WynntilsLootrunPathsScreen;
import com.wynntils.services.lootrunpaths.LootrunPathsService;
import com.wynntils.services.lootrunpaths.type.LootrunNote;
import com.wynntils.services.lootrunpaths.type.LootrunSaveResult;
import com.wynntils.services.lootrunpaths.type.LootrunState;
import com.wynntils.services.lootrunpaths.type.LootrunUndoResult;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.PosUtils;
import java.io.File;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;

public class LootrunCommand
extends Command {
    private static final SuggestionProvider<CommandSourceStack> LOOTRUN_SUGGESTION_PROVIDER = (context, suggestions) -> SharedSuggestionProvider.suggest(Stream.of(LootrunPathsService.LOOTRUNS.list()).map(name -> name.replaceAll("\\.json$", "")).map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)suggestions);

    @Override
    public String getCommandName() {
        return "lootrun";
    }

    @Override
    public List<String> getAliases() {
        return List.of("lr");
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> getCommandBuilder(LiteralArgumentBuilder<CommandSourceStack> base, CommandBuildContext context) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)base.then(Commands.literal((String)"load").then(Commands.argument((String)"lootrun", (ArgumentType)StringArgumentType.string()).suggests(LOOTRUN_SUGGESTION_PROVIDER).executes(this::loadLootrun)))).then(Commands.literal((String)"record").executes(this::recordLootrun))).then(Commands.literal((String)"save").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(this::saveLootrun)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"note").then(((LiteralArgumentBuilder)Commands.literal((String)"add").then(Commands.literal((String)"json").then(Commands.argument((String)"text", (ArgumentType)ComponentArgument.textComponent((CommandBuildContext)context)).executes(this::addJsonLootrunNote)))).then(Commands.literal((String)"text").then(Commands.argument((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(this::addTextLootrunNote))))).then(Commands.literal((String)"list").executes(this::listLootrunNote))).then(Commands.literal((String)"delete").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(this::deleteLootrunNote))))).then(Commands.literal((String)"clear").executes(this::clearLootrun))).then(Commands.literal((String)"delete").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(LOOTRUN_SUGGESTION_PROVIDER).executes(this::deleteLootrun)))).then(Commands.literal((String)"rename").then(Commands.argument((String)"old", (ArgumentType)StringArgumentType.string()).suggests(LOOTRUN_SUGGESTION_PROVIDER).then(Commands.argument((String)"new", (ArgumentType)StringArgumentType.string()).executes(this::renameLootrun))))).then(((LiteralArgumentBuilder)Commands.literal((String)"chest").then(Commands.literal((String)"add").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(this::addChest)))).then(Commands.literal((String)"remove").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(this::removeChest))))).then(Commands.literal((String)"undo").executes(this::undoLootrun))).then(Commands.literal((String)"folder").executes(this::folderLootrun))).then(Commands.literal((String)"screen").executes(this::screenLootrun))).executes(this::syntaxError);
    }

    private int loadLootrun(CommandContext<CommandSourceStack> context) {
        String fileName = StringArgumentType.getString(context, (String)"lootrun");
        Services.LootrunPaths.tryLoadLootrun(fileName);
        return 1;
    }

    private int recordLootrun(CommandContext<CommandSourceStack> context) {
        if (Services.LootrunPaths.getState() != LootrunState.RECORDING) {
            Services.LootrunPaths.startRecording();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.wynntils.lootrun.recordStart", (Object[])new Object[]{Component.literal((String)"/lootrun record").withStyle(ChatFormatting.UNDERLINE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lootrun record")))}), false);
        } else {
            Services.LootrunPaths.stopRecording();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.wynntils.lootrun.recordStop1", (Object[])new Object[]{Component.literal((String)"/lootrun clear").withStyle(ChatFormatting.UNDERLINE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lootrun clear")))}).withStyle(ChatFormatting.RED).append("\n").append((Component)Component.translatable((String)"command.wynntils.lootrun.recordStop2", (Object[])new Object[]{Component.literal((String)"/lootrun save <name>").withStyle(ChatFormatting.UNDERLINE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/lootrun save ")))}).withStyle(ChatFormatting.GREEN)), false);
        }
        return 1;
    }

    private int saveLootrun(CommandContext<CommandSourceStack> context) {
        String name = StringArgumentType.getString(context, (String)"name");
        LootrunSaveResult lootrunSaveResult = Services.LootrunPaths.saveCurrentLootrun(name);
        if (lootrunSaveResult == null) {
            return 0;
        }
        switch (lootrunSaveResult) {
            case SAVED: {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.wynntils.lootrun.savedLootrun").withStyle(ChatFormatting.GREEN), false);
                return 1;
            }
            case ERROR_SAVING: {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.wynntils.lootrun.errorSavingLootrun").withStyle(ChatFormatting.RED));
                return 0;
            }
            case ERROR_ALREADY_EXISTS: {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.wynntils.lootrun.errorSavingLootrunAlreadyExists").withStyle(ChatFormatting.RED));
                return 0;
            }
        }
        return 0;
    }

    private int addJsonLootrunNote(CommandContext<CommandSourceStack> context) {
        Component text = ComponentArgument.getComponent(context, (String)"text");
        Entity root = McUtils.player().getRootVehicle();
        BlockPos pos = root.blockPosition();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.wynntils.lootrun.addedNote", (Object[])new Object[]{pos.toShortString()}).append("\n" + String.valueOf(text)), false);
        return Services.LootrunPaths.addNote(text);
    }

    private int addTextLootrunNote(CommandContext<CommandSourceStack> context) {
        MutableComponent text = Component.literal((String)StringArgumentType.getString(context, (String)"text"));
        Entity root = McUtils.player().getRootVehicle();
        BlockPos pos = root.blockPosition();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> LootrunCommand.lambda$addTextLootrunNote$9(pos, (Component)text), false);
        return Services.LootrunPaths.addNote((Component)text);
    }

    private int listLootrunNote(CommandContext<CommandSourceStack> context) {
        List<LootrunNote> notes = Services.LootrunPaths.getCurrentNotes();
        if (notes.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.wynntils.lootrun.listNoteNoNote"));
        } else {
            MutableComponent component = Component.translatable((String)"command.wynntils.lootrun.listNoteHeader");
            for (LootrunNote note : notes) {
                BlockPos pos = PosUtils.newBlockPos(note.position());
                String posString = pos.toShortString();
                component.append("\n").append((Component)Component.literal((String)"[X]").withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"command.wynntils.lootrun.listClickToDelete"))).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lootrun note delete " + posString.replace(",", ""))).withColor(ChatFormatting.RED))).append(" " + posString + ": ").append(note.component());
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> component, false);
        }
        return 1;
    }

    private int deleteLootrunNote(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.getSpawnablePos(context, (String)"pos");
        LootrunNote removedNote = Services.LootrunPaths.deleteNoteAt(pos);
        if (removedNote != null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.wynntils.lootrun.noteRemovedSuccessfully", (Object[])new Object[]{pos.toShortString(), removedNote.component()}).withStyle(ChatFormatting.GREEN), false);
        } else {
            String posString = pos.toShortString();
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.wynntils.lootrun.noteUnableToFind", (Object[])new Object[]{posString}));
        }
        return Services.LootrunPaths.recompileLootrun(true);
    }

    private int clearLootrun(CommandContext<CommandSourceStack> context) {
        if (Services.LootrunPaths.getState() == LootrunState.DISABLED) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.wynntils.lootrun.noActiveLootrun"));
            return 0;
        }
        Services.LootrunPaths.clearCurrentLootrun();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.wynntils.lootrun.clearSuccessful").withStyle(ChatFormatting.GREEN), false);
        return 1;
    }

    private int deleteLootrun(CommandContext<CommandSourceStack> context) {
        String name = StringArgumentType.getString(context, (String)"name");
        File file = new File(LootrunPathsService.LOOTRUNS, name + ".json");
        if (!file.exists()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.wynntils.lootrun.lootrunDoesntExist", (Object[])new Object[]{name}));
        } else {
            if (file.delete()) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.wynntils.lootrun.lootrunDeleted", (Object[])new Object[]{name}).withStyle(ChatFormatting.GREEN), false);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.wynntils.lootrun.lootrunCouldNotBeDeleted", (Object[])new Object[]{name}));
        }
        return 0;
    }

    private int renameLootrun(CommandContext<CommandSourceStack> context) {
        String oldName = StringArgumentType.getString(context, (String)"old");
        String newName = StringArgumentType.getString(context, (String)"new");
        File oldFile = new File(LootrunPathsService.LOOTRUNS, oldName + ".json");
        File newFile = new File(LootrunPathsService.LOOTRUNS, newName + ".json");
        if (!oldFile.exists()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.wynntils.lootrun.lootrunDoesntExist", (Object[])new Object[]{oldName}));
        } else {
            if (oldFile.renameTo(newFile)) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.wynntils.lootrun.lootrunRenamed", (Object[])new Object[]{oldName, newName}).withStyle(ChatFormatting.GREEN), false);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.wynntils.lootrun.lootrunCouldNotBeRenamed", (Object[])new Object[]{oldName, newName}));
        }
        return 0;
    }

    private int addChest(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.getSpawnablePos(context, (String)"pos");
        boolean successful = Services.LootrunPaths.addChest(pos);
        if (successful) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.wynntils.lootrun.chestAdded", (Object[])new Object[]{pos.toShortString()}).withStyle(ChatFormatting.GREEN), false);
        } else {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.wynntils.lootrun.chestAlreadyAdded", (Object[])new Object[]{pos.toShortString()}));
        }
        return Services.LootrunPaths.recompileLootrun(true);
    }

    private int removeChest(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.getSpawnablePos(context, (String)"pos");
        boolean successful = Services.LootrunPaths.removeChest(pos);
        if (successful) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.wynntils.lootrun.chestRemoved", (Object[])new Object[]{pos.toShortString()}).withStyle(ChatFormatting.GREEN), false);
        } else {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.wynntils.lootrun.chestDoesNotExist", (Object[])new Object[]{pos.toShortString()}));
        }
        return Services.LootrunPaths.recompileLootrun(true);
    }

    private int undoLootrun(CommandContext<CommandSourceStack> context) {
        if (Services.LootrunPaths.getState() != LootrunState.RECORDING) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.wynntils.lootrun.notRecording"));
        } else {
            LootrunUndoResult lootrunUndoResult = Services.LootrunPaths.tryUndo();
            switch (lootrunUndoResult) {
                case SUCCESSFUL: {
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.wynntils.lootrun.undoSuccessful"), false);
                    return 1;
                }
                case ERROR_STAND_NEAR_POINT: {
                    ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.wynntils.lootrun.undoStandNear"));
                    return 0;
                }
                case ERROR_NOT_FAR_ENOUGH: {
                    ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.wynntils.lootrun.undoNotFarEnough"));
                    return 0;
                }
            }
        }
        return 0;
    }

    private int folderLootrun(CommandContext<CommandSourceStack> context) {
        Util.getPlatform().openFile(LootrunPathsService.LOOTRUNS);
        return 1;
    }

    private int syntaxError(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Missing argument").withStyle(ChatFormatting.RED));
        return 0;
    }

    private int screenLootrun(CommandContext<CommandSourceStack> context) {
        Managers.TickScheduler.scheduleLater(() -> WynntilsMenuScreenBase.openBook(WynntilsLootrunPathsScreen.create()), 2);
        return 1;
    }

    private static /* synthetic */ Component lambda$addTextLootrunNote$9(BlockPos pos, Component text) {
        return Component.translatable((String)"command.wynntils.lootrun.addedNote", (Object[])new Object[]{pos.toShortString()}).append("\n" + String.valueOf(text));
    }
}

