/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.commands.Command;
import com.wynntils.models.worlds.profile.ServerProfile;
import com.wynntils.utils.StringUtils;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;

public class ServersCommand
extends Command {
    private static final int UPDATE_TIME_OUT_MS = 3000;
    private static final SuggestionProvider<CommandSourceStack> SERVERS_SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest(Models.ServerList.getServers(), (SuggestionsBuilder)builder);

    @Override
    public String getCommandName() {
        return "servers";
    }

    @Override
    protected List<String> getAliases() {
        return List.of("s", "srv");
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> getCommandBuilder(LiteralArgumentBuilder<CommandSourceStack> base, CommandBuildContext context) {
        LiteralCommandNode listBuilder = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"list").then(Commands.literal((String)"up").executes(this::serverUptimeList))).executes(this::serverList)).build();
        LiteralCommandNode infoBuilder = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"info").then(Commands.argument((String)"server", (ArgumentType)StringArgumentType.word()).suggests(SERVERS_SUGGESTION_PROVIDER).executes(this::serverInfo))).executes(this::serverInfo)).build();
        LiteralArgumentBuilder infoAliasBuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"i").then(Commands.argument((String)"server", (ArgumentType)StringArgumentType.word()).suggests(SERVERS_SUGGESTION_PROVIDER).executes(this::serverInfo))).executes(this::serverInfo);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)base.then((CommandNode)listBuilder)).then((CommandNode)infoBuilder)).then(Commands.literal((String)"l").executes(this::serverList))).then(Commands.literal((String)"ul").executes(this::serverUptimeList))).then(Commands.literal((String)"up").executes(this::serverUptimeList))).then((ArgumentBuilder)infoAliasBuilder)).executes(this::syntaxError);
    }

    private int serverInfo(CommandContext<CommandSourceStack> context) {
        Object server;
        try {
            server = (String)context.getArgument("server", String.class);
        }
        catch (Exception e) {
            server = Models.WorldState.getCurrentWorldName();
        }
        try {
            int serverNum = Integer.parseInt((String)server);
            server = Models.WorldState.getCurrentServerRegion().name() + serverNum;
        }
        catch (Exception ignored) {
            server = ((String)server).toUpperCase(Locale.ROOT);
        }
        ServerProfile serverProfile = Models.ServerList.getServer((String)server);
        if (serverProfile == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)((String)server + " not found.")).withStyle(ChatFormatting.RED));
            return 1;
        }
        Set<String> players = serverProfile.getPlayers();
        MutableComponent message = Component.empty().append((Component)this.getServerComponent((String)server).withStyle(ChatFormatting.GOLD)).append((Component)Component.literal((String)":\n").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)"Uptime: ").withStyle(ChatFormatting.DARK_AQUA).append((Component)Component.literal((String)(serverProfile.getUptime() + "\n")).withStyle(ChatFormatting.AQUA))).append((Component)Component.literal((String)"Online players on ").withStyle(ChatFormatting.DARK_AQUA).append((Component)Component.literal((String)server).withStyle(ChatFormatting.AQUA)).append((Component)Component.literal((String)": ").withStyle(ChatFormatting.DARK_AQUA)).append((Component)Component.literal((String)(players.size() + "\n")).withStyle(ChatFormatting.AQUA))));
        if (players.isEmpty()) {
            message.append((Component)Component.literal((String)"No players!").withStyle(ChatFormatting.AQUA));
        } else {
            message.append((Component)Component.literal((String)String.join((CharSequence)", ", players)).withStyle(ChatFormatting.AQUA));
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> message, false);
        return 1;
    }

    private int serverList(CommandContext<CommandSourceStack> context) {
        MutableComponent message = Component.literal((String)"Server list:").withStyle(ChatFormatting.DARK_AQUA);
        for (String serverType : Models.ServerList.getWynnServerTypes()) {
            List<String> currentTypeServers = Models.ServerList.getServersSortedOnNameOfType(serverType);
            if (currentTypeServers.isEmpty()) continue;
            message.append("\n");
            message.append((Component)Component.literal((String)(StringUtils.capitalizeFirst(serverType) + " (" + currentTypeServers.size() + "):\n")).withStyle(ChatFormatting.GOLD));
            String lastServer = currentTypeServers.getLast();
            for (String server : currentTypeServers) {
                message.append((Component)this.getServerComponent(server).withStyle(ChatFormatting.AQUA));
                if (server.equals(lastServer)) continue;
                message.append((Component)Component.literal((String)", ").withStyle(ChatFormatting.DARK_AQUA));
            }
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> message, false);
        return 1;
    }

    private int serverUptimeList(CommandContext<CommandSourceStack> context) {
        List<String> sortedServers = Models.ServerList.getServersSortedOnUptime();
        MutableComponent message = Component.literal((String)"Server list:").withStyle(ChatFormatting.GOLD);
        for (String server : sortedServers) {
            message.append("\n");
            message.append((Component)this.getServerComponent(server).withStyle(ChatFormatting.DARK_AQUA).append((Component)Component.literal((String)(": " + Models.ServerList.getServer(server).getUptime())).withStyle(ChatFormatting.AQUA)));
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> message, false);
        return 1;
    }

    private int syntaxError(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Missing argument").withStyle(ChatFormatting.RED));
        return 0;
    }

    private MutableComponent getServerComponent(String server) {
        return Component.literal((String)server).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to switch to ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)server).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)"\n(Requires ").withStyle(ChatFormatting.DARK_PURPLE).append((Component)Component.literal((String)"HERO").withStyle(ChatFormatting.LIGHT_PURPLE)).append((Component)Component.literal((String)" rank)").withStyle(ChatFormatting.DARK_PURPLE)))))).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/switch " + server)));
    }
}

