/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.commands.Command;
import com.wynntils.services.statistics.type.StatisticEntry;
import com.wynntils.services.statistics.type.StatisticKind;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class StatisticsCommand
extends Command {
    private static final SuggestionProvider<CommandSourceStack> STATISTIC_SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.suggest(Arrays.stream(StatisticKind.values()).map(StatisticKind::getId), (SuggestionsBuilder)builder);

    @Override
    public String getCommandName() {
        return "statistics";
    }

    @Override
    public List<String> getAliases() {
        return List.of("stats", "stat", "st");
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> getCommandBuilder(LiteralArgumentBuilder<CommandSourceStack> base, CommandBuildContext context) {
        RequiredArgumentBuilder characterStatisticsBuilder = (RequiredArgumentBuilder)Commands.argument((String)"statistic", (ArgumentType)StringArgumentType.greedyString()).suggests(STATISTIC_SUGGESTION_PROVIDER).executes(this::getStatistic);
        RequiredArgumentBuilder overallStatisticsBuilder = (RequiredArgumentBuilder)Commands.argument((String)"statistic", (ArgumentType)StringArgumentType.greedyString()).suggests(STATISTIC_SUGGESTION_PROVIDER).executes(this::getStatisticOverall);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)base.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"show").then(Commands.literal((String)"overall").executes(this::showOverallStatistics))).then(Commands.literal((String)"o").executes(this::showOverallStatistics))).executes(this::showCharacterStatistics))).then(Commands.literal((String)"list").executes(this::listStatistics))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"get").then(Commands.literal((String)"character").then((ArgumentBuilder)characterStatisticsBuilder))).then(Commands.literal((String)"c").then((ArgumentBuilder)characterStatisticsBuilder))).then(Commands.literal((String)"overall").then((ArgumentBuilder)overallStatisticsBuilder))).then(Commands.literal((String)"o").then((ArgumentBuilder)overallStatisticsBuilder)))).then(((LiteralArgumentBuilder)Commands.literal((String)"reset").then(Commands.literal((String)"confirm").executes(this::doResetStatistics))).executes(this::resetStatistics))).executes(this::syntaxError);
    }

    private int showCharacterStatistics(CommandContext<CommandSourceStack> context) {
        MutableComponent response = Component.literal((String)"Statistics:").withStyle(ChatFormatting.AQUA);
        for (StatisticKind statistic : Arrays.stream(StatisticKind.values()).sorted(Comparator.comparing(StatisticKind::getName)).toList()) {
            long value = Services.Statistics.getStatistic(statistic).total();
            response.append((Component)Component.literal((String)"\n - ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)statistic.getName()).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)": ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)statistic.getFormattedValue(value)).withStyle(ChatFormatting.DARK_GREEN));
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> response, false);
        return 1;
    }

    private int showOverallStatistics(CommandContext<CommandSourceStack> context) {
        MutableComponent response = Component.literal((String)"Statistics:").withStyle(ChatFormatting.AQUA);
        for (StatisticKind statistic : Arrays.stream(StatisticKind.values()).sorted(Comparator.comparing(StatisticKind::getName)).toList()) {
            long value = Services.Statistics.getOverallStatistic(statistic).total();
            response.append((Component)Component.literal((String)"\n - ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)statistic.getName()).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)": ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)statistic.getFormattedValue(value)).withStyle(ChatFormatting.DARK_GREEN));
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> response, false);
        return 1;
    }

    private int listStatistics(CommandContext<CommandSourceStack> context) {
        MutableComponent response = Component.literal((String)"Available kinds of statistics:").withStyle(ChatFormatting.AQUA);
        for (StatisticKind statistic : Arrays.stream(StatisticKind.values()).sorted(Comparator.comparing(StatisticKind::getId)).toList()) {
            response.append((Component)Component.literal((String)"\n - ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)statistic.getId()).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)(" (" + statistic.getName() + ")")).withStyle(ChatFormatting.DARK_GREEN));
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> response, false);
        return 1;
    }

    private int getStatistic(CommandContext<CommandSourceStack> context) {
        String statisticId = (String)context.getArgument("statistic", String.class);
        StatisticKind statistic = StatisticKind.from(statisticId);
        if (statistic == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"No such statistic.").withStyle(ChatFormatting.RED));
            return 0;
        }
        StatisticEntry value = Services.Statistics.getStatistic(statistic);
        MutableComponent response = StatisticsCommand.getStatisticComponent(statistic, value);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> response, false);
        return 1;
    }

    private int getStatisticOverall(CommandContext<CommandSourceStack> context) {
        String statisticId = (String)context.getArgument("statistic", String.class);
        StatisticKind statistic = StatisticKind.from(statisticId);
        if (statistic == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"No such statistic.").withStyle(ChatFormatting.RED));
            return 0;
        }
        StatisticEntry value = Services.Statistics.getOverallStatistic(statistic);
        MutableComponent response = StatisticsCommand.getStatisticComponent(statistic, value);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> response, false);
        return 1;
    }

    private static MutableComponent getStatisticComponent(StatisticKind statistic, StatisticEntry value) {
        MutableComponent response = Component.literal((String)statistic.getName()).withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)":\nTotal: ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)statistic.getFormattedValue(value.total())).withStyle(ChatFormatting.DARK_GREEN)).append((Component)Component.literal((String)"\nCount: ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)statistic.getFormattedValue(value.count())).withStyle(ChatFormatting.DARK_GREEN)).append((Component)Component.literal((String)"\nMin: ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)statistic.getFormattedValue(value.min())).withStyle(ChatFormatting.DARK_GREEN)).append((Component)Component.literal((String)"\nMax: ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)statistic.getFormattedValue(value.max())).withStyle(ChatFormatting.DARK_GREEN)).append((Component)Component.literal((String)"\nAverage: ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)statistic.getFormattedValue(value.average())).withStyle(ChatFormatting.DARK_GREEN));
        return response;
    }

    private int resetStatistics(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.wynntils.statistics.warnReset").withStyle(ChatFormatting.AQUA), false);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.wynntils.statistics.clickHere").withStyle(ChatFormatting.RED).withStyle(ChatFormatting.UNDERLINE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/statistics reset confirm"))), false);
        return 1;
    }

    private int doResetStatistics(CommandContext<CommandSourceStack> context) {
        Services.Statistics.resetStatistics();
        MutableComponent response = Component.literal((String)"All statistics for this character has been reset").withStyle(ChatFormatting.AQUA);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> response, false);
        return 1;
    }

    private int syntaxError(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Missing argument").withStyle(ChatFormatting.RED));
        return 0;
    }
}

