/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.consumers.overlays;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.overlays.DynamicOverlay;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedFontRenderer;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.CappedValue;
import com.wynntils.utils.type.ErrorOr;
import com.wynntils.utils.type.Pair;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;

public abstract class BarOverlay
extends DynamicOverlay {
    @Persisted(i18nKey="overlay.wynntils.barOverlay.textShadow")
    private final Config<TextShadow> textShadow = new Config<TextShadow>(TextShadow.OUTLINE);
    @Persisted(i18nKey="overlay.wynntils.barOverlay.flip")
    private final Config<Boolean> flip = new Config<Boolean>(false);
    @Persisted(i18nKey="overlay.wynntils.barOverlay.animationTime")
    private final Config<Float> animationTime = new Config<Float>(Float.valueOf(2.0f));
    @Persisted(i18nKey="overlay.wynntils.barOverlay.heightModifier")
    private final Config<Float> heightModifier = new Config<Float>(Float.valueOf(1.0f));
    private Pair<StyledText, ErrorOr<CappedValue>> templateCache;
    private float currentProgress = 0.0f;

    protected BarOverlay(int id, OverlaySize overlaySize) {
        super(id);
        this.size.store(overlaySize);
    }

    protected BarOverlay(OverlayPosition position, OverlaySize size) {
        super(position, size, 1);
    }

    @Override
    public void render(GuiGraphics guiGraphics, MultiBufferSource bufferSource, DeltaTracker deltaTracker, Window window) {
        PoseStack poseStack = guiGraphics.pose();
        BarOverlayTemplatePair template = this.getTemplate();
        if (this.templateCache == null) {
            this.templateCache = this.calculateTemplate(template);
        }
        this.render(poseStack, bufferSource, this.currentProgress, this.templateCache.key());
    }

    @Override
    public void renderPreview(GuiGraphics guiGraphics, MultiBufferSource bufferSource, DeltaTracker deltaTracker, Window window) {
        PoseStack poseStack = guiGraphics.pose();
        BarOverlayTemplatePair previewTemplate = this.getPreviewTemplate();
        Pair<StyledText, ErrorOr<CappedValue>> calculatedTemplate = this.calculateTemplate(previewTemplate);
        ErrorOr<CappedValue> valueOrError = calculatedTemplate.value();
        if (valueOrError.hasError()) {
            this.renderText(poseStack, bufferSource, this.getModifiedRenderY(10.0f), StyledText.fromString(valueOrError.getError()));
            return;
        }
        if (valueOrError.getValue().equals(CappedValue.EMPTY)) {
            return;
        }
        this.render(poseStack, bufferSource, (float)valueOrError.getValue().getProgress(), calculatedTemplate.key());
    }

    @Override
    protected void renderOrErrorMessage(GuiGraphics guiGraphics, MultiBufferSource bufferSource, DeltaTracker deltaTracker, Window window) {
        if (this.templateCache == null) {
            return;
        }
        if (this.templateCache.b().hasError()) {
            StyledText[] errorMessage = new StyledText[]{StyledText.fromString("\u00a7c\u00a7l" + I18n.get((String)"overlay.wynntils.barOverlay.valueTemplate.error", (Object[])new Object[0]) + " " + this.getTranslatedName()), StyledText.fromUnformattedString(this.templateCache.b().getError())};
            BufferedFontRenderer.getInstance().renderAlignedTextInBox(guiGraphics.pose(), bufferSource, errorMessage, this.getRenderX(), this.getRenderX() + this.getWidth(), this.getRenderY(), this.getRenderY() + this.getHeight(), 0.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 1.0f);
        } else {
            super.renderOrErrorMessage(guiGraphics, bufferSource, deltaTracker, window);
        }
    }

    private void render(PoseStack poseStack, MultiBufferSource bufferSource, float renderedProgress, StyledText textValue) {
        float barHeight = this.getTextureHeight() * ((Float)this.heightModifier.get()).floatValue();
        float renderY = this.getModifiedRenderY(barHeight + 10.0f);
        this.renderText(poseStack, bufferSource, renderY, textValue);
        float progress = (float)((Boolean)this.flip.get() != false ? -1 : 1) * renderedProgress;
        this.renderBar(poseStack, bufferSource, renderY + 10.0f, barHeight, progress);
    }

    @Override
    public void tick() {
        if (!this.isRendered()) {
            return;
        }
        BarOverlayTemplatePair template = this.getTemplate();
        this.templateCache = this.calculateTemplate(template);
        if (this.templateCache.b().hasError()) {
            return;
        }
        CappedValue value = this.templateCache.b().getValue();
        if (value == CappedValue.EMPTY) {
            return;
        }
        if (((Float)this.animationTime.get()).floatValue() == 0.0f) {
            this.currentProgress = (float)value.getProgress();
            return;
        }
        this.currentProgress = (float)((double)this.currentProgress - (double)(((Float)this.animationTime.get()).floatValue() * 0.1f) * ((double)this.currentProgress - value.getProgress()));
    }

    private Pair<StyledText, ErrorOr<CappedValue>> calculateTemplate(BarOverlayTemplatePair template) {
        return Pair.of(StyledText.join(" ", Managers.Function.doFormatLines(template.textTemplate)), Managers.Function.tryGetRawValueOfType(template.valueTemplate, CappedValue.class));
    }

    protected abstract float getTextureHeight();

    protected void renderBar(PoseStack poseStack, MultiBufferSource bufferSource, float renderY, float renderHeight, float progress) {
        Texture texture = this.getTexture();
        if (this.getRenderColor() == CommonColors.WHITE) {
            BufferedRenderUtils.drawProgressBar(poseStack, bufferSource, texture, this.getRenderX(), renderY, this.getRenderX() + this.getWidth(), renderY + renderHeight, 0, 0, texture.width(), texture.height(), progress);
        } else {
            BufferedRenderUtils.drawColoredProgressBar(poseStack, bufferSource, texture, this.getRenderColor(), this.getRenderX(), renderY, this.getRenderX() + this.getWidth(), renderY + renderHeight, 0, 0, texture.width(), texture.height(), progress);
        }
    }

    private void renderText(PoseStack poseStack, MultiBufferSource bufferSource, float renderY, StyledText text) {
        BufferedFontRenderer.getInstance().renderAlignedTextInBox(poseStack, bufferSource, text, this.getRenderX(), this.getRenderX() + this.getWidth(), renderY, 0.0f, this.getRenderColor(), this.getRenderHorizontalAlignment(), (TextShadow)this.textShadow.get());
    }

    private float getModifiedRenderY(float renderedHeight) {
        return switch (this.getRenderVerticalAlignment()) {
            default -> throw new MatchException(null, null);
            case VerticalAlignment.TOP -> this.getRenderY();
            case VerticalAlignment.MIDDLE -> this.getRenderY() + (this.getHeight() - renderedHeight) / 2.0f;
            case VerticalAlignment.BOTTOM -> this.getRenderY() + this.getHeight() - renderedHeight;
        };
    }

    protected abstract Texture getTexture();

    protected CustomColor getRenderColor() {
        return CommonColors.WHITE;
    }

    public float getTextScale() {
        return 1.0f;
    }

    protected abstract BarOverlayTemplatePair getTemplate();

    protected abstract BarOverlayTemplatePair getPreviewTemplate();

    public record BarOverlayTemplatePair(String textTemplate, String valueTemplate) {
    }
}

