/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.net;

import com.wynntils.core.components.CoreComponent;
import com.wynntils.core.net.UrlId;
import com.wynntils.utils.type.Pair;
import java.util.List;
import java.util.Set;

public abstract class Dependency {
    private static final Dependency EMPTY = new Dependency(){

        @Override
        public List<Pair<CoreComponent, UrlId>> dependencies() {
            return List.of();
        }

        public String toString() {
            return "EmptyDependency{}";
        }
    };

    public abstract List<Pair<CoreComponent, UrlId>> dependencies();

    public final boolean dependsOn(CoreComponent component, UrlId urlId) {
        return this.dependencies().stream().anyMatch(pair -> pair.a() == component && pair.b() == urlId);
    }

    public static Dependency empty() {
        return EMPTY;
    }

    public static Dependency simple(CoreComponent component, UrlId urlId) {
        return new SimpleComponentDataDependency(component, urlId);
    }

    public static Dependency multi(CoreComponent component, Set<UrlId> urlIds) {
        return new SingleComponentMultiDataDependency(component, urlIds);
    }

    public static Dependency complex(Set<Dependency> dependencies) {
        return new ComplexDependency(dependencies);
    }

    private static final class SimpleComponentDataDependency
    extends Dependency {
        private final CoreComponent component;
        private final UrlId urlId;

        private SimpleComponentDataDependency(CoreComponent component, UrlId urlId) {
            this.component = component;
            this.urlId = urlId;
        }

        @Override
        public List<Pair<CoreComponent, UrlId>> dependencies() {
            return List.of(Pair.of(this.component, this.urlId));
        }

        public String toString() {
            return "SimpleComponentDataDependency{component=" + String.valueOf(this.component) + ", urlId=" + String.valueOf((Object)this.urlId) + "}";
        }
    }

    private static final class SingleComponentMultiDataDependency
    extends Dependency {
        private final CoreComponent component;
        private final Set<UrlId> urlIds;

        private SingleComponentMultiDataDependency(CoreComponent component, Set<UrlId> urlIds) {
            this.component = component;
            this.urlIds = urlIds;
        }

        @Override
        public List<Pair<CoreComponent, UrlId>> dependencies() {
            return this.urlIds.stream().map(urlId -> Pair.of(this.component, urlId)).toList();
        }

        public String toString() {
            return "SingleComponentMultiDataDependency{component=" + String.valueOf(this.component) + ", urlIds=" + String.valueOf(this.urlIds) + "}";
        }
    }

    private static final class ComplexDependency
    extends Dependency {
        private final Set<Dependency> dependencies;

        private ComplexDependency(Set<Dependency> dependencies) {
            this.dependencies = dependencies;
        }

        @Override
        public List<Pair<CoreComponent, UrlId>> dependencies() {
            return this.dependencies.stream().flatMap(dependency -> dependency.dependencies().stream()).toList();
        }

        public String toString() {
            return "ComplexDependency{dependencies=" + String.valueOf(this.dependencies) + "}";
        }
    }
}

