/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.net;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.net.event.NetResultProcessedEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.http.HttpRequest;
import java.net.http.HttpTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;

public abstract class NetResult {
    private static final Consumer<Throwable> DEFAULT_ERROR_HANDLER = exception -> WynntilsMod.error("Error while processing network request; ignored");
    protected final HttpRequest request;
    private final String desc;
    private final NetResultProcessedEvent processedEvent;

    protected NetResult(String desc, HttpRequest request, NetResultProcessedEvent processedEvent) {
        this.request = request;
        this.desc = desc;
        this.processedEvent = processedEvent;
    }

    public void handleInputStream(Consumer<InputStream> handler, Consumer<Throwable> onError) {
        this.doHandle(handler, onError);
    }

    public void handleInputStream(Consumer<InputStream> handler) {
        this.handleInputStream(handler, DEFAULT_ERROR_HANDLER);
    }

    public void handleReader(Consumer<Reader> handler, Consumer<Throwable> onError) {
        this.handleInputStream(is -> handler.accept(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8)), onError);
    }

    public void handleReader(Consumer<Reader> handler) {
        this.handleReader(handler, DEFAULT_ERROR_HANDLER);
    }

    public void handleJsonObject(Consumer<JsonObject> handler, Consumer<Throwable> onError) {
        this.handleReader(reader -> {
            try {
                handler.accept(JsonParser.parseReader((Reader)reader).getAsJsonObject());
            }
            catch (Throwable t) {
                WynntilsMod.warn("Failure in net manager [handleJsonObject], processing " + this.desc + ": " + t.getMessage());
                onError.accept(t);
            }
        }, onError);
    }

    public void handleJsonObject(Consumer<JsonObject> handler) {
        this.handleJsonObject(handler, DEFAULT_ERROR_HANDLER);
    }

    public void handleJsonArray(Consumer<JsonArray> handler, Consumer<Throwable> onError) {
        this.handleReader(reader -> {
            try {
                handler.accept(JsonParser.parseReader((Reader)reader).getAsJsonArray());
            }
            catch (Throwable t) {
                WynntilsMod.warn("Failure in net manager [handleJsonArray], processing " + this.desc, t);
                onError.accept(t);
            }
        }, onError);
    }

    public void handleJsonArray(Consumer<JsonArray> handler) {
        this.handleJsonArray(handler, DEFAULT_ERROR_HANDLER);
    }

    private void doHandle(Consumer<InputStream> onCompletion, Consumer<Throwable> onError) {
        CompletionStage future = ((CompletableFuture)this.getInputStreamFuture().thenAccept((Consumer)this.wrappingHandler(onCompletion, onError))).exceptionally(t -> {
            CompletionException ce;
            Throwable patt0$temp;
            if (t instanceof CompletionException && (patt0$temp = (ce = (CompletionException)t).getCause()) instanceof HttpTimeoutException) {
                HttpTimeoutException hte = (HttpTimeoutException)patt0$temp;
                WynntilsMod.warn("Failure in net manager [doHandle], processing " + this.desc + ", HttpTimeoutException: " + hte.getMessage());
            } else {
                WynntilsMod.warn("Failure in net manager [doHandle], processing " + this.desc, t);
            }
            onError.accept((Throwable)t);
            return null;
        });
    }

    private Consumer<InputStream> wrappingHandler(Consumer<InputStream> handler, Consumer<Throwable> onError) {
        return inputStream -> {
            try {
                Thread.currentThread().setContextClassLoader(WynntilsMod.class.getClassLoader());
                handler.accept((InputStream)inputStream);
                if (this.processedEvent != null) {
                    WynntilsMod.postEventOnMainThread(this.processedEvent);
                }
            }
            catch (Throwable t) {
                WynntilsMod.warn("Failure in net manager [wrappingHandler], processing " + this.desc, t);
                onError.accept(t);
                this.onHandlingFailed();
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        };
    }

    protected void onHandlingFailed() {
    }

    protected abstract CompletableFuture<InputStream> getInputStreamFuture();
}

