/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.notifications;

import com.wynntils.core.text.StyledText;
import com.wynntils.utils.render.TextRenderSetting;
import com.wynntils.utils.render.TextRenderTask;
import java.util.Objects;

public class MessageContainer {
    private StyledText message;
    private TextRenderTask renderTask;
    private int messageCount;

    public MessageContainer(String message) {
        this(new TextRenderTask(message, TextRenderSetting.DEFAULT));
    }

    public MessageContainer(TextRenderTask message) {
        this.message = message.getText();
        this.renderTask = message;
        this.messageCount = 1;
    }

    public StyledText getMessage() {
        return this.message;
    }

    public TextRenderTask getRenderTask() {
        return this.renderTask;
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public void setMessageCount(int newCount) {
        this.messageCount = newCount;
        this.updateRenderTask();
    }

    void editMessage(StyledText newMessage) {
        this.message = newMessage;
        this.updateRenderTask();
    }

    private void updateRenderTask() {
        if (this.messageCount == 1) {
            this.renderTask = new TextRenderTask(this.message, TextRenderSetting.DEFAULT);
        } else {
            StyledText messageMultiplier = StyledText.fromString(" \u00a77[x" + this.messageCount + "]");
            this.renderTask = new TextRenderTask(this.message.append(messageMultiplier), this.renderTask.getSetting());
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MessageContainer that = (MessageContainer)other;
        return this.messageCount == that.messageCount && this.message.equals(that.message);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.messageCount);
    }
}

