/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.persisted.upfixers.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.wynntils.core.persisted.PersistedValue;
import com.wynntils.core.persisted.upfixers.Upfixer;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CustomPoiIconEnumBugUpfixer
implements Upfixer {
    private static final String POI_LIST_KEY = "mapFeature.customPois";
    private static final Pattern POI_NAME_CHEST_PATTERN = Pattern.compile("Loot Chest T?(\\d)");

    @Override
    public boolean apply(JsonObject configObject, Set<PersistedValue<?>> persisteds) {
        for (PersistedValue<?> persisted : persisteds) {
            if (!persisted.getJsonName().equals(POI_LIST_KEY)) continue;
            JsonElement obj = configObject.get(POI_LIST_KEY);
            if (obj == null) {
                return true;
            }
            JsonArray array = obj.getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                String icon;
                JsonObject poi = array.get(i).getAsJsonObject();
                if (!poi.has("icon") || !(icon = poi.get("icon").getAsString()).equals("bubbleBar")) continue;
                String name = poi.get("name").getAsString();
                Matcher matcher = POI_NAME_CHEST_PATTERN.matcher(name);
                if (!matcher.matches()) {
                    poi.addProperty("icon", "chestT1");
                    continue;
                }
                String tier = matcher.group(1);
                poi.addProperty("icon", "chestT" + tier);
            }
        }
        return true;
    }
}

