/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.persisted.upfixers.storage;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.wynntils.core.persisted.PersistedValue;
import com.wynntils.core.persisted.upfixers.Upfixer;
import java.util.Set;

public class BankPageNameToBankPagePropertyUpfixer
implements Upfixer {
    private static final String[] NORMAL_KEY_TEMPLATES = new String[]{"model.bank.customAccountBankPage%s", "model.bank.customBlockBankPage%s", "model.bank.customBookshelfPage%s", "model.bank.customMiscBucketPage%s"};
    private static final String CHARACTER_BANK_KEY_TEMPALTE = "model.bank.customCharacterBankPages%s";

    @Override
    public boolean apply(JsonObject configObject, Set<PersistedValue<?>> persisteds) {
        BankPageNameToBankPagePropertyUpfixer.migrateNormalKeys(configObject);
        BankPageNameToBankPagePropertyUpfixer.migrateCharacterBank(configObject);
        return true;
    }

    private static void migrateNormalKeys(JsonObject configObject) {
        for (String keyTemplate : NORMAL_KEY_TEMPLATES) {
            String nameKey = String.format(keyTemplate, "Names");
            if (!configObject.has(nameKey)) continue;
            JsonObject names = configObject.get(nameKey).getAsJsonObject();
            String customizationKey = String.format(keyTemplate, "Customizations");
            configObject.add(customizationKey, (JsonElement)BankPageNameToBankPagePropertyUpfixer.createCustomizationsFromNames(names));
            configObject.remove(nameKey);
        }
    }

    private static void migrateCharacterBank(JsonObject configObject) {
        String nameKey = String.format(CHARACTER_BANK_KEY_TEMPALTE, "Names");
        if (configObject.has(nameKey)) {
            JsonObject oldCharacters = configObject.get(nameKey).getAsJsonObject();
            JsonObject newCharacters = new JsonObject();
            for (String characterId : oldCharacters.keySet()) {
                JsonObject names = oldCharacters.get(characterId).getAsJsonObject();
                newCharacters.add(characterId, (JsonElement)BankPageNameToBankPagePropertyUpfixer.createCustomizationsFromNames(names));
            }
            String customizationKey = String.format(CHARACTER_BANK_KEY_TEMPALTE, "Customizations");
            configObject.add(customizationKey, (JsonElement)newCharacters);
            configObject.remove(nameKey);
        }
    }

    private static JsonObject createCustomizationsFromNames(JsonObject names) {
        JsonObject customizations = new JsonObject();
        for (String pageIndex : names.keySet()) {
            String customName = names.get(pageIndex).getAsString();
            JsonObject obj = new JsonObject();
            obj.addProperty("name", customName);
            obj.addProperty("icon", "none");
            customizations.add(pageIndex, (JsonElement)obj);
        }
        return customizations;
    }
}

