/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.labels.event.LabelIdentifiedEvent;
import com.wynntils.handlers.labels.event.TextDisplayChangedEvent;
import com.wynntils.handlers.labels.type.LabelInfo;
import com.wynntils.models.guild.label.GuildSeasonLeaderboardLabelInfo;
import com.wynntils.models.guild.profile.GuildProfile;
import com.wynntils.models.guild.type.GuildLeaderboardInfo;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.colors.ColorChatFormatting;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.bus.api.SubscribeEvent;

public class ExtendedSeasonLeaderboardFeature
extends Feature {
    private final Map<Integer, Map<Integer, Long>> seasonRatings = new HashMap<Integer, Map<Integer, Long>>();
    @Persisted
    private final Config<Boolean> useShortSeasonRankingStrings = new Config<Boolean>(false);
    @Persisted
    private final Config<Boolean> highlightOwnGuild = new Config<Boolean>(true);
    @Persisted
    private final Config<ColorChatFormatting> guildHighlightColor = new Config<ColorChatFormatting>(ColorChatFormatting.GREEN);

    @SubscribeEvent
    public void onLabelIdentified(LabelIdentifiedEvent event) {
        LabelInfo labelInfo = event.getLabelInfo();
        if (labelInfo instanceof GuildSeasonLeaderboardLabelInfo) {
            GuildSeasonLeaderboardLabelInfo guildSeasonLeaderboardLabelInfo = (GuildSeasonLeaderboardLabelInfo)labelInfo;
            Map seasonMap = this.seasonRatings.getOrDefault(guildSeasonLeaderboardLabelInfo.getSeason(), new HashMap());
            guildSeasonLeaderboardLabelInfo.getGuildLeaderboardInfo().forEach(guildLeaderboardInfo -> seasonMap.put(guildLeaderboardInfo.position(), guildLeaderboardInfo.rating()));
            this.seasonRatings.put(guildSeasonLeaderboardLabelInfo.getSeason(), seasonMap);
        }
    }

    @SubscribeEvent
    public void onLabelChanged(TextDisplayChangedEvent.Text event) {
        if (event.getLabelInfo().isEmpty()) {
            return;
        }
        LabelInfo labelInfo = event.getLabelInfo().get();
        if (labelInfo instanceof GuildSeasonLeaderboardLabelInfo) {
            GuildSeasonLeaderboardLabelInfo guildSeasonLeaderboardLabelInfo = (GuildSeasonLeaderboardLabelInfo)labelInfo;
            event.setText(this.getUpdatedLeaderboard(guildSeasonLeaderboardLabelInfo));
        }
    }

    private StyledText getUpdatedLeaderboard(GuildSeasonLeaderboardLabelInfo guildSeasonLeaderboardLabelInfo) {
        MutableComponent newLabel = Component.empty().append((Component)Component.literal((String)("Season " + guildSeasonLeaderboardLabelInfo.getSeason() + " Leaderboard")).withStyle(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.BOLD}));
        if (guildSeasonLeaderboardLabelInfo.isCurrentSeason()) {
            int seasonEnd = guildSeasonLeaderboardLabelInfo.getEndingDate().getFirst();
            newLabel.append((Component)Component.literal((String)"\nSeason ends in ").withStyle(ChatFormatting.GRAY));
            newLabel.append((Component)Component.literal((String)(seasonEnd + " " + guildSeasonLeaderboardLabelInfo.getTimeUnit() + " \n\n")).withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}));
        } else {
            int endMonth = guildSeasonLeaderboardLabelInfo.getEndingDate().getFirst();
            int endDay = guildSeasonLeaderboardLabelInfo.getEndingDate().get(1);
            int endYear = guildSeasonLeaderboardLabelInfo.getEndingDate().get(2);
            String formattedDate = String.format("%02d/%02d/%d", endMonth, endDay, endYear);
            newLabel.append((Component)Component.literal((String)"\nSeason ended at ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)(formattedDate + "\n\n")).withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}));
        }
        Map seasonMap = this.seasonRatings.getOrDefault(guildSeasonLeaderboardLabelInfo.getSeason(), new HashMap());
        for (GuildLeaderboardInfo leaderboardPos : guildSeasonLeaderboardLabelInfo.getGuildLeaderboardInfo()) {
            ChatFormatting placeColor = ChatFormatting.GRAY;
            if (leaderboardPos.position() <= 3) {
                placeColor = ChatFormatting.GOLD;
            } else if (leaderboardPos.position() <= 6) {
                placeColor = ChatFormatting.YELLOW;
            } else if (leaderboardPos.position() <= 9) {
                placeColor = ChatFormatting.WHITE;
            }
            MutableComponent placement = Component.literal((String)String.valueOf(leaderboardPos.position())).withStyle(placeColor);
            if (leaderboardPos.position() == 1) {
                placement.withStyle(ChatFormatting.BOLD);
            }
            newLabel.append((Component)placement).append((Component)Component.literal((String)" - ")).withStyle(ChatFormatting.GRAY);
            Optional<GuildProfile> guildProfile = Models.Guild.getGuildProfile(leaderboardPos.guildName());
            String prefix = "[" + guildProfile.map(GuildProfile::prefix).orElse("???") + "]";
            ChatFormatting guildColor = ChatFormatting.AQUA;
            if (((Boolean)this.highlightOwnGuild.get()).booleanValue() && leaderboardPos.guildName().equals(Models.Guild.getGuildName())) {
                guildColor = ((ColorChatFormatting)((Object)this.guildHighlightColor.get())).getChatFormatting();
            }
            Object scoreString = (Boolean)this.useShortSeasonRankingStrings.get() != false ? "(" + StringUtils.integerToShortString(leaderboardPos.rating()) + ") SR" : String.format("(%,d SR)", leaderboardPos.rating());
            long lowerGuildRating = seasonMap.getOrDefault(leaderboardPos.position() + 1, -1L);
            Object ratingDifference = " (+???)";
            if (lowerGuildRating != -1L) {
                long difference = leaderboardPos.rating() - lowerGuildRating;
                ratingDifference = ((Boolean)this.useShortSeasonRankingStrings.get()).booleanValue() ? " (+" + StringUtils.integerToShortString(difference) + ")" : String.format(" (+%,d)", difference);
            } else if (guildSeasonLeaderboardLabelInfo.isLastPage()) {
                ratingDifference = "";
            }
            newLabel.append((Component)Component.literal((String)(leaderboardPos.guildName() + " " + prefix)).withStyle(guildColor)).append((Component)Component.literal((String)(" " + (String)scoreString)).withStyle(ChatFormatting.LIGHT_PURPLE)).append((Component)Component.literal((String)ratingDifference).withStyle(ChatFormatting.GREEN)).append("\n");
        }
        ChatFormatting previousPageColor = guildSeasonLeaderboardLabelInfo.isFirstPage() ? ChatFormatting.GRAY : ChatFormatting.GREEN;
        ChatFormatting nextPageColor = guildSeasonLeaderboardLabelInfo.isLastPage() ? ChatFormatting.GRAY : ChatFormatting.GREEN;
        newLabel.append((Component)Component.literal((String)"\n\u00ab").withStyle(new ChatFormatting[]{previousPageColor, ChatFormatting.BOLD})).append((Component)Component.literal((String)" \u2b1f ").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)"\u00bb").withStyle(new ChatFormatting[]{nextPageColor, ChatFormatting.BOLD})).append((Component)Component.literal((String)"\nClick for Options").withStyle(ChatFormatting.YELLOW));
        return StyledText.fromComponent((Component)newLabel);
    }
}

