/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.combat;

import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.PlayerAttackEvent;
import com.wynntils.mc.event.PlayerInteractEvent;
import com.wynntils.utils.wynn.ItemUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.COMBAT)
public class PreventTradesDuelsFeature
extends Feature {
    @Persisted
    private final Config<Boolean> onlyWhileFighting = new Config<Boolean>(true);
    @Persisted
    private final Config<Integer> fightingTimeCutoff = new Config<Integer>(10);
    @Persisted
    private final Config<Boolean> whenHoldingGatheringTool = new Config<Boolean>(false);

    @SubscribeEvent
    public void onPlayerRightClick(PlayerInteractEvent.Interact event) {
        this.handlePlayerClick(event, event.getPlayer(), event.getItemStack(), event.getTarget());
    }

    @SubscribeEvent
    public void onPlayerLeftClick(PlayerAttackEvent event) {
        this.handlePlayerClick(event, event.getPlayer(), event.getPlayer().getMainHandItem(), event.getTarget());
    }

    private void handlePlayerClick(ICancellableEvent event, Player player, ItemStack itemStack, Entity target) {
        Player p;
        if (!(player.isShiftKeyDown() && target instanceof Player && Models.Player.isLocalPlayer(p = (Player)target))) {
            return;
        }
        int timeSinceLastFight = (int)((System.currentTimeMillis() - Models.Combat.getLastDamageDealtTimestamp()) / 1000L);
        if (ItemUtils.isWeapon(itemStack) && ((Boolean)this.onlyWhileFighting.get()).booleanValue() && timeSinceLastFight < (Integer)this.fightingTimeCutoff.get()) {
            event.setCanceled(true);
            Managers.Notification.queueMessage(StyledText.fromString(String.valueOf(ChatFormatting.BLUE) + "Trade/Duel blocked for " + ((Integer)this.fightingTimeCutoff.get() - timeSinceLastFight) + " s"));
        } else if (ItemUtils.isGatheringTool(itemStack) && ((Boolean)this.whenHoldingGatheringTool.get()).booleanValue()) {
            event.setCanceled(true);
            Managers.Notification.queueMessage(StyledText.fromString(String.valueOf(ChatFormatting.BLUE) + "Trade/Duel blocked whilst holding gathering tool"));
        }
    }
}

