/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.embellishments;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.StartDisabled;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.SetSlotEvent;
import com.wynntils.models.items.properties.ShinyItemProperty;
import com.wynntils.utils.mc.McUtils;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.DyedItemColor;
import net.neoforged.bus.api.SubscribeEvent;

@StartDisabled
@ConfigCategory(value=Category.EMBELLISHMENTS)
public class RemoveShinyGlintFeature
extends Feature {
    private static final int SHINY_GLINT_COLOR = 0x1FFF00;
    @Persisted
    private final Config<Boolean> replaceGlint = new Config<Boolean>(true);

    @SubscribeEvent
    public void onSetSlot(SetSlotEvent.Pre event) {
        this.removeOrReplaceGlint(event.getItemStack());
    }

    @Override
    public void onEnable() {
        if (McUtils.player() == null) {
            return;
        }
        McUtils.inventory().items.forEach(this::removeOrReplaceGlint);
    }

    private void removeOrReplaceGlint(ItemStack itemStack) {
        Optional<ShinyItemProperty> shinyItemProperty = Models.Item.asWynnItemProperty(itemStack, ShinyItemProperty.class);
        if (shinyItemProperty.isEmpty()) {
            return;
        }
        if (shinyItemProperty.isPresent() && shinyItemProperty.get().getShinyStat().isEmpty()) {
            return;
        }
        PotionContents itemStackPotionContents = (PotionContents)itemStack.get(DataComponents.POTION_CONTENTS);
        if (itemStackPotionContents == null) {
            DyedItemColor dyeColor = (DyedItemColor)itemStack.get(DataComponents.DYED_COLOR);
            if (dyeColor == null) {
                return;
            }
            if (dyeColor.rgb() != 0x1FFF00) {
                return;
            }
            itemStack.remove(DataComponents.DYED_COLOR);
            if (((Boolean)this.replaceGlint.get()).booleanValue()) {
                itemStack.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
            }
        } else {
            Optional potionColor = itemStackPotionContents.customColor();
            if (potionColor.isEmpty()) {
                return;
            }
            if ((Integer)potionColor.get() != 0x1FFF00) {
                return;
            }
            PotionContents removedContents = new PotionContents(itemStackPotionContents.potion(), Optional.empty(), itemStackPotionContents.customEffects(), itemStackPotionContents.customName());
            itemStack.set(DataComponents.POTION_CONTENTS, (Object)removedContents);
            if (((Boolean)this.replaceGlint.get()).booleanValue()) {
                itemStack.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
            }
        }
    }
}

