/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.ContainerClickEvent;
import com.wynntils.mc.event.ContainerCloseEvent;
import com.wynntils.mc.event.ContainerSetContentEvent;
import com.wynntils.mc.event.ContainerSetSlotEvent;
import com.wynntils.mc.event.InventoryKeyPressEvent;
import com.wynntils.mc.event.ScreenInitEvent;
import com.wynntils.mc.event.SlotRenderEvent;
import com.wynntils.mc.extension.ScreenExtension;
import com.wynntils.models.containers.containers.ContentBookContainer;
import com.wynntils.models.containers.containers.CosmeticContainer;
import com.wynntils.models.containers.containers.GuildBadgesContainer;
import com.wynntils.models.containers.containers.GuildBankContainer;
import com.wynntils.models.containers.containers.GuildMemberListContainer;
import com.wynntils.models.containers.containers.GuildTerritoriesContainer;
import com.wynntils.models.containers.containers.HousingJukeboxContainer;
import com.wynntils.models.containers.containers.HousingListContainer;
import com.wynntils.models.containers.containers.JukeboxContainer;
import com.wynntils.models.containers.containers.personal.AccountBankContainer;
import com.wynntils.models.containers.containers.personal.BookshelfContainer;
import com.wynntils.models.containers.containers.personal.CharacterBankContainer;
import com.wynntils.models.containers.containers.personal.IslandBlockBankContainer;
import com.wynntils.models.containers.containers.personal.MiscBucketContainer;
import com.wynntils.models.containers.containers.personal.PersonalBlockBankContainer;
import com.wynntils.models.containers.containers.personal.PersonalStorageContainer;
import com.wynntils.models.containers.type.SearchableContainerProperty;
import com.wynntils.models.items.WynnItem;
import com.wynntils.screens.base.TextboxScreen;
import com.wynntils.screens.base.widgets.ItemFilterUIButton;
import com.wynntils.screens.base.widgets.ItemSearchWidget;
import com.wynntils.screens.base.widgets.SearchWidget;
import com.wynntils.services.itemfilter.type.ItemSearchQuery;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.wynn.ContainerUtils;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.INVENTORY)
public class ContainerSearchFeature
extends Feature {
    @Persisted
    private final Config<Boolean> filterInBank = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> filterInBlockBank = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> filterInBookshelf = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> filterInMiscBucket = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> filterInGuildBank = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> filterInGuildMemberList = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> filterInCosmeticMenus = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> filterInContentBook = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> filterInGuildTerritories = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> filterInGuildBadges = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> filterInHousingJukebox = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> filterInHousingList = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> filterInJukebox = new Config<Boolean>(true);
    @Persisted
    private final Config<CustomColor> highlightColor = new Config<CustomColor>(CommonColors.MAGENTA);
    private final Map<Class<? extends SearchableContainerProperty>, Supplier<Boolean>> searchableContainerMap;
    private static final int GUILD_BANK_SEARCH_DELAY = 500;
    private long guildBankLastSearch;
    private SearchWidget lastSearchWidget;
    private SearchableContainerProperty currentContainer;
    private boolean autoSearching;
    private boolean matchedItems;
    private int direction;
    private ItemSearchQuery lastSearchQuery;

    public ContainerSearchFeature() {
        Map.Entry[] entryArray = new Map.Entry[15];
        entryArray[0] = Map.entry(AccountBankContainer.class, this.filterInBank::get);
        entryArray[1] = Map.entry(BookshelfContainer.class, this.filterInBookshelf::get);
        entryArray[2] = Map.entry(CharacterBankContainer.class, this.filterInBank::get);
        entryArray[3] = Map.entry(ContentBookContainer.class, this.filterInContentBook::get);
        entryArray[4] = Map.entry(GuildBankContainer.class, this.filterInGuildBank::get);
        entryArray[5] = Map.entry(GuildBadgesContainer.class, this.filterInGuildBadges::get);
        entryArray[6] = Map.entry(GuildMemberListContainer.class, this.filterInGuildMemberList::get);
        entryArray[7] = Map.entry(GuildTerritoriesContainer.class, this.filterInGuildTerritories::get);
        entryArray[8] = Map.entry(HousingJukeboxContainer.class, this.filterInHousingJukebox::get);
        entryArray[9] = Map.entry(HousingListContainer.class, this.filterInHousingList::get);
        entryArray[10] = Map.entry(IslandBlockBankContainer.class, this.filterInBlockBank::get);
        entryArray[11] = Map.entry(JukeboxContainer.class, this.filterInJukebox::get);
        entryArray[12] = Map.entry(MiscBucketContainer.class, this.filterInMiscBucket::get);
        entryArray[13] = Map.entry(PersonalBlockBankContainer.class, this.filterInBlockBank::get);
        entryArray[14] = Map.entry(CosmeticContainer.class, this.filterInCosmeticMenus::get);
        this.searchableContainerMap = Map.ofEntries(entryArray);
        this.guildBankLastSearch = 0L;
        this.autoSearching = false;
        this.matchedItems = false;
        this.direction = 0;
    }

    @SubscribeEvent
    public void onScreenInit(ScreenInitEvent.Pre event) {
        Screen screen = event.getScreen();
        if (!(screen instanceof AbstractContainerScreen)) {
            return;
        }
        AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
        if (!(screen2.getMenu() instanceof ChestMenu)) {
            return;
        }
        int renderX = (screen2.width - screen2.imageWidth) / 2;
        int renderY = (screen2.height - screen2.imageHeight) / 2;
        this.currentContainer = this.getCurrentSearchableContainer();
        if (this.currentContainer == null) {
            return;
        }
        this.matchedItems = false;
        SearchableContainerProperty searchableContainerProperty = this.currentContainer;
        if (searchableContainerProperty instanceof SearchableContainerProperty) {
            SearchableContainerProperty searchableContainer = searchableContainerProperty;
            renderY -= searchableContainer.renderYOffset();
        }
        this.addWidgets((AbstractContainerScreen<ChestMenu>)screen2, renderX, renderY);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onRenderSlot(SlotRenderEvent.CountPre e) {
        ItemStack itemStack = e.getSlot().getItem();
        Optional<WynnItem> wynnItemOpt = Models.Item.getWynnItem(itemStack);
        if (wynnItemOpt.isEmpty()) {
            return;
        }
        Boolean result = (Boolean)wynnItemOpt.get().getData().get("searched");
        if (result == null || !result.booleanValue()) {
            return;
        }
        RenderSystem.enableDepthTest();
        RenderUtils.drawArc(e.getPoseStack(), (CustomColor)this.highlightColor.get(), e.getSlot().x, e.getSlot().y, 100.0f, 1.0f, 6, 8);
        RenderSystem.disableDepthTest();
    }

    @SubscribeEvent
    public void onContainerSetContent(ContainerSetContentEvent.Post event) {
        Screen screen;
        if (this.currentContainer == null) {
            return;
        }
        this.forceUpdateSearch();
        if (!this.matchedItems && this.autoSearching && (screen = McUtils.screen()) instanceof AbstractContainerScreen) {
            AbstractContainerScreen abstractContainerScreen = (AbstractContainerScreen)screen;
            this.tryAutoSearch(abstractContainerScreen);
        }
    }

    @SubscribeEvent
    public void onContainerSetSlot(ContainerSetSlotEvent.Pre event) {
        if (this.currentContainer == null) {
            return;
        }
        this.forceUpdateSearch();
    }

    @SubscribeEvent
    public void onSlotClicked(ContainerClickEvent e) {
        this.autoSearching = false;
    }

    @SubscribeEvent
    public void onContainerClose(ContainerCloseEvent.Post event) {
        this.lastSearchWidget = null;
        this.lastSearchQuery = null;
        this.currentContainer = null;
        this.autoSearching = false;
        this.matchedItems = false;
        this.direction = 0;
        this.guildBankLastSearch = 0L;
    }

    @SubscribeEvent
    public void onInventoryKeyPress(InventoryKeyPressEvent event) {
        if (event.getKeyCode() == 257 && !Models.Bank.isEditingMode()) {
            AbstractContainerScreen abstractContainerScreen;
            Screen screen;
            if (this.lastSearchWidget == null || this.lastSearchWidget.getTextBoxInput().isEmpty() || this.currentContainer == null || !((screen = McUtils.screen()) instanceof AbstractContainerScreen) || !((screen = (abstractContainerScreen = (AbstractContainerScreen)screen).getMenu()) instanceof ChestMenu)) {
                return;
            }
            ChestMenu chestMenu = (ChestMenu)screen;
            abstractContainerScreen.clearFocus();
            TextboxScreen textboxScreen = (TextboxScreen)abstractContainerScreen;
            textboxScreen.setFocusedTextInput(null);
            this.direction = 1;
            StyledText nextItemName = StyledText.fromComponent(((ItemStack)chestMenu.getItems().get(this.currentContainer.getNextItemSlot())).getHoverName());
            if (!nextItemName.matches(this.currentContainer.getNextItemPattern())) {
                this.direction = -1;
            }
            if (abstractContainerScreen.hoveredSlot != null) {
                if (abstractContainerScreen.hoveredSlot.index == this.currentContainer.getNextItemSlot()) {
                    this.direction = 1;
                } else if (abstractContainerScreen.hoveredSlot.index == this.currentContainer.getPreviousItemSlot()) {
                    this.direction = -1;
                }
            }
            this.autoSearching = true;
            if (KeyboardUtils.isShiftDown() && this.currentContainer instanceof PersonalStorageContainer) {
                ContainerUtils.pressKeyOnSlot(7, abstractContainerScreen.getMenu().containerId, 0, (List<ItemStack>)abstractContainerScreen.getMenu().getItems());
                return;
            }
            this.tryAutoSearch(abstractContainerScreen);
        }
    }

    private void tryAutoSearch(AbstractContainerScreen<?> abstractContainerScreen) {
        Pattern itemPattern;
        if (!this.autoSearching) {
            return;
        }
        if (this.currentContainer instanceof GuildBankContainer) {
            long diff = System.currentTimeMillis() - this.guildBankLastSearch;
            if (diff < 500L) {
                Managers.TickScheduler.scheduleLater(() -> this.tryAutoSearch(abstractContainerScreen), (int)(500L - diff) / 50);
                return;
            }
            this.guildBankLastSearch = System.currentTimeMillis();
        }
        int slot = this.direction == 1 ? this.currentContainer.getNextItemSlot() : this.currentContainer.getPreviousItemSlot();
        StyledText name = StyledText.fromComponent(((ItemStack)abstractContainerScreen.getMenu().getItems().get(slot)).getHoverName());
        Pattern pattern = itemPattern = this.direction == 1 ? this.currentContainer.getNextItemPattern() : this.currentContainer.getPreviousItemPattern();
        if (!name.matches(itemPattern)) {
            this.autoSearching = false;
            return;
        }
        ContainerUtils.clickOnSlot(slot, abstractContainerScreen.getMenu().containerId, 0, (List<ItemStack>)abstractContainerScreen.getMenu().getItems());
    }

    private SearchableContainerProperty getCurrentSearchableContainer() {
        com.wynntils.models.containers.Container container = Models.Container.getCurrentContainer();
        if (container instanceof SearchableContainerProperty) {
            SearchableContainerProperty searchableContainer = (SearchableContainerProperty)((Object)container);
            for (Map.Entry entry : this.searchableContainerMap.entrySet()) {
                if (!((Class)entry.getKey()).isInstance(searchableContainer) || !((Boolean)((Supplier)entry.getValue()).get()).booleanValue()) continue;
                return searchableContainer;
            }
        }
        return null;
    }

    private void addWidgets(AbstractContainerScreen<ChestMenu> screen, int renderX, int renderY) {
        if (this.currentContainer.supportsAdvancedSearch()) {
            ItemSearchWidget searchWidget = new ItemSearchWidget(renderX + screen.imageWidth - 175, renderY - 20, 155, 20, this.currentContainer.supportedProviderTypes(), false, query -> {
                this.lastSearchQuery = query;
                this.matchItemsAdvanced(this.lastSearchQuery, (ChestMenu)screen.getMenu());
            }, (ScreenExtension)screen);
            if (this.lastSearchWidget != null) {
                searchWidget.setTextBoxInput(this.lastSearchWidget.getTextBoxInput());
            }
            this.lastSearchWidget = searchWidget;
            screen.addRenderableWidget((GuiEventListener)this.lastSearchWidget);
            screen.addRenderableWidget((GuiEventListener)new ItemFilterUIButton(renderX + 157, renderY - 20, this.lastSearchWidget, (Screen)screen, false, this.currentContainer.supportedProviderTypes()));
        } else {
            SearchWidget searchWidget = new SearchWidget(renderX + screen.imageWidth - 175, renderY - 20, 175, 20, s -> this.matchItemsBasic((String)s, (ChestMenu)screen.getMenu()), (ScreenExtension)screen);
            if (this.lastSearchWidget != null) {
                searchWidget.setTextBoxInput(this.lastSearchWidget.getTextBoxInput());
            }
            this.lastSearchWidget = searchWidget;
            screen.addRenderableWidget((GuiEventListener)this.lastSearchWidget);
        }
    }

    private void matchItemsAdvanced(ItemSearchQuery searchQuery, ChestMenu chestMenu) {
        this.matchedItems = false;
        if (searchQuery == null) {
            return;
        }
        Container container = chestMenu.getContainer();
        for (int i = 0; i < container.getContainerSize(); ++i) {
            ItemStack itemStack;
            Optional<WynnItem> wynnItemOpt;
            if (!this.currentContainer.getBounds().getSlots().contains(i) || (wynnItemOpt = Models.Item.getWynnItem(itemStack = container.getItem(i))).isEmpty()) continue;
            boolean filtered = !searchQuery.isEmpty() && Services.ItemFilter.matches(searchQuery, itemStack);
            wynnItemOpt.get().getData().store("searched", filtered);
            if (!filtered) continue;
            this.matchedItems = true;
        }
    }

    private void matchItemsBasic(String searchStr, ChestMenu chestMenu) {
        String search = searchStr.toLowerCase(Locale.ROOT);
        this.matchedItems = false;
        Container container = chestMenu.getContainer();
        for (int i = 0; i < container.getContainerSize(); ++i) {
            ItemStack itemStack;
            Optional<WynnItem> wynnItemOpt;
            if (!this.currentContainer.getBounds().getSlots().contains(i) || (wynnItemOpt = Models.Item.getWynnItem(itemStack = container.getItem(i))).isEmpty()) continue;
            String name = StyledText.fromComponent(itemStack.getHoverName()).getStringWithoutFormatting().toLowerCase(Locale.ROOT);
            boolean filtered = !search.isEmpty() && name.contains(search) && !itemStack.isEmpty();
            wynnItemOpt.get().getData().store("searched", filtered);
            if (!filtered) continue;
            this.matchedItems = true;
        }
    }

    private void forceUpdateSearch() {
        AbstractContainerScreen abstractContainerScreen;
        AbstractContainerMenu abstractContainerMenu;
        Screen screen = McUtils.screen();
        if (this.lastSearchWidget != null && screen instanceof AbstractContainerScreen && (abstractContainerMenu = (abstractContainerScreen = (AbstractContainerScreen)screen).getMenu()) instanceof ChestMenu) {
            ChestMenu chestMenu = (ChestMenu)abstractContainerMenu;
            if (this.currentContainer.supportsAdvancedSearch()) {
                this.matchItemsAdvanced(this.lastSearchQuery, chestMenu);
            } else {
                this.matchItemsBasic(this.lastSearchWidget.getTextBoxInput(), chestMenu);
            }
        }
    }
}

