/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.overlays;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.overlays.annotations.OverlayInfo;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.RenderEvent;
import com.wynntils.models.raid.event.RaidEndedEvent;
import com.wynntils.models.raid.event.RaidNewBestTimeEvent;
import com.wynntils.overlays.RaidProgressOverlay;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.mc.McUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.OVERLAYS)
public class RaidProgressFeature
extends Feature {
    private static final String TIME_FORMAT_MILLISECONDS = "%02d:%02d.%03d";
    private static final String TIME_FORMAT_SECONDS = "%02d:%02d";
    @OverlayInfo(renderType=RenderEvent.ElementType.GUI)
    private final RaidProgressOverlay raidProgressOverlay = new RaidProgressOverlay();
    @Persisted
    private final Config<Boolean> printTimes = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> playSoundOnBest = new Config<Boolean>(true);

    @SubscribeEvent
    public void onRaidCompleted(RaidEndedEvent.Completed event) {
        int i;
        if (!((Boolean)this.printTimes.get()).booleanValue()) {
            return;
        }
        if (event.getRaid().completedChallengeCount() == 0) {
            WynntilsMod.error("Completed raid but no completed rooms were tracked");
            return;
        }
        MutableComponent raidComponents = Component.literal((String)"");
        raidComponents.append((Component)Component.literal((String)event.getRaid().getRaidKind().getRaidName()).withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.UNDERLINE));
        raidComponents.append((Component)Component.literal((String)"\n\n"));
        for (i = 0; i < event.getRaid().getRaidKind().getChallengeCount(); ++i) {
            if (event.getRaid().getRoomByNumber(i + 1) == null) {
                WynntilsMod.warn("Completed raid " + event.getRaid().getRaidKind().getRaidName() + " but missing challenge room " + i);
                continue;
            }
            raidComponents.append((Component)Component.literal((String)(event.getRaid().getRoomByNumber(i + 1).getRoomName() + ": ")).withStyle(ChatFormatting.LIGHT_PURPLE));
            raidComponents.append((Component)Component.literal((String)this.formatTime(event.getRaid().getRoomByNumber(i + 1).getRoomTotalTime())).withStyle(ChatFormatting.AQUA));
            if (((Boolean)this.raidProgressOverlay.showDamage.get()).booleanValue()) {
                raidComponents.append((Component)Component.literal((String)" (").withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)StringUtils.integerToShortString(event.getRaid().getRoomByNumber(i + 1).getRoomDamage())).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)")").withStyle(ChatFormatting.WHITE));
            }
            raidComponents.append((Component)Component.literal((String)"\n"));
        }
        raidComponents.append((Component)Component.literal((String)"\n"));
        for (i = 0; i < event.getRaid().getRaidKind().getBossCount(); ++i) {
            int bossRoomNum = i + event.getRaid().getRaidKind().getChallengeCount() + 1;
            if (event.getRaid().getRoomByNumber(bossRoomNum) == null) {
                WynntilsMod.warn("Completed raid " + event.getRaid().getRaidKind().getRaidName() + " but missing boss room " + bossRoomNum);
                continue;
            }
            String bossName = event.getRaid().getRoomByNumber(bossRoomNum).getRoomName();
            if (bossName.equals("The ##### Anomaly")) {
                raidComponents.append((Component)Component.literal((String)"The ").withStyle(ChatFormatting.DARK_RED)).append((Component)Component.literal((String)"#####").withStyle(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.OBFUSCATED})).append((Component)Component.literal((String)" Anomaly: ").withStyle(ChatFormatting.DARK_RED));
            } else {
                raidComponents.append((Component)Component.literal((String)(bossName + ": ")).withStyle(ChatFormatting.DARK_RED));
            }
            raidComponents.append((Component)Component.literal((String)this.formatTime(event.getRaid().getRoomByNumber(bossRoomNum).getRoomTotalTime())).withStyle(ChatFormatting.AQUA));
            if (((Boolean)this.raidProgressOverlay.showDamage.get()).booleanValue()) {
                raidComponents.append((Component)Component.literal((String)" (").withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)StringUtils.integerToShortString(event.getRaid().getRoomByNumber(bossRoomNum).getRoomDamage())).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)")").withStyle(ChatFormatting.WHITE));
            }
            raidComponents.append((Component)Component.literal((String)"\n"));
        }
        if (((Boolean)this.raidProgressOverlay.showIntermission.get()).booleanValue()) {
            raidComponents.append((Component)Component.literal((String)"\nIntermission: ").withStyle(ChatFormatting.DARK_GRAY));
            raidComponents.append((Component)Component.literal((String)this.formatTime(event.getRaid().getIntermissionTime())).withStyle(ChatFormatting.AQUA));
        }
        raidComponents.append((Component)Component.literal((String)"\nTotal: ").withStyle(ChatFormatting.DARK_PURPLE));
        long raidTime = event.getRaid().getTimeInRaid() - ((Boolean)this.raidProgressOverlay.totalIntermission.get() != false ? 0L : event.getRaid().getIntermissionTime());
        raidComponents.append((Component)Component.literal((String)this.formatTime(raidTime)).withStyle(ChatFormatting.AQUA));
        if (((Boolean)this.raidProgressOverlay.showDamage.get()).booleanValue()) {
            raidComponents.append((Component)Component.literal((String)" (").withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)StringUtils.integerToShortString(event.getRaid().getRaidDamage())).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)")").withStyle(ChatFormatting.WHITE));
        }
        McUtils.sendMessageToClient((Component)raidComponents);
    }

    @SubscribeEvent
    public void onRaidPersonalBest(RaidNewBestTimeEvent event) {
        if (!((Boolean)this.printTimes.get()).booleanValue()) {
            return;
        }
        long minutes = event.getTime() / 1000L / 60L;
        long seconds = event.getTime() / 1000L % 60L;
        long milliseconds = event.getTime() % 1000L;
        McUtils.sendMessageToClient((Component)Component.translatable((String)"feature.wynntils.raidProgress.personalBest", (Object[])new Object[]{event.getRaidName(), minutes, seconds, milliseconds}).withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.BOLD));
        if (((Boolean)this.playSoundOnBest.get()).booleanValue()) {
            McUtils.playSoundAmbient(SoundEvents.FIREWORK_ROCKET_LARGE_BLAST);
        }
    }

    private String formatTime(long time) {
        long minutes = time / 1000L / 60L;
        long seconds = time / 1000L % 60L;
        long milliseconds = time % 1000L;
        if (((Boolean)this.raidProgressOverlay.showMilliseconds.get()).booleanValue()) {
            return String.format(TIME_FORMAT_MILLISECONDS, minutes, seconds, milliseconds);
        }
        return String.format(TIME_FORMAT_SECONDS, minutes, seconds);
    }
}

