/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.ui;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.MouseScrollEvent;
import com.wynntils.models.containers.Container;
import com.wynntils.models.containers.type.ScrollableContainerProperty;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.wynn.ContainerUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.UI)
public class ContainerScrollFeature
extends Feature {
    @Persisted
    private final Config<Boolean> invertScroll = new Config<Boolean>(false);

    @SubscribeEvent
    public void onInteract(MouseScrollEvent event) {
        Screen screen = McUtils.screen();
        if (!(screen instanceof AbstractContainerScreen)) {
            return;
        }
        AbstractContainerScreen gui = (AbstractContainerScreen)screen;
        boolean scrollBack = event.isScrollingUp() ^ (Boolean)this.invertScroll.get();
        Container container = Models.Container.getCurrentContainer();
        if (container instanceof ScrollableContainerProperty) {
            ScrollableContainerProperty scrollableContainer = (ScrollableContainerProperty)((Object)container);
            Optional<Integer> slot = scrollableContainer.getScrollButton(gui, scrollBack);
            if (slot.isEmpty()) {
                return;
            }
            event.setCanceled(true);
            ContainerUtils.clickOnSlot(slot.get(), gui.getMenu().containerId, 0, (List<ItemStack>)gui.getMenu().getItems());
        }
    }
}

