/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.ui;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.ItemTooltipRenderEvent;
import com.wynntils.models.items.items.gui.ServerItem;
import com.wynntils.models.worlds.profile.ServerProfile;
import com.wynntils.utils.mc.LoreUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.UI)
public class LobbyUptimeFeature
extends Feature {
    @SubscribeEvent
    public void onTooltipPre(ItemTooltipRenderEvent.Pre event) {
        Optional<ServerItem> serverItemOpt = Models.Item.asWynnItem(event.getItemStack(), ServerItem.class);
        if (serverItemOpt.isEmpty()) {
            return;
        }
        List<Component> tooltips = LoreUtils.appendTooltip(event.getItemStack(), event.getTooltips(), this.getTooltipAddon(serverItemOpt.get()));
        event.setTooltips(tooltips);
    }

    private List<Component> getTooltipAddon(ServerItem serverItem) {
        ArrayList<Component> addon = new ArrayList<Component>();
        String serverId = serverItem.getRegion().name() + serverItem.getServerId();
        ServerProfile serverProfile = Models.ServerList.getServer(serverId);
        String uptimeString = serverProfile == null ? "Unknown" : serverProfile.getUptime();
        addon.add((Component)Component.literal((String)"Uptime: ").withStyle(ChatFormatting.DARK_GREEN).append((Component)Component.literal((String)uptimeString).withStyle(ChatFormatting.GREEN)));
        return addon;
    }
}

