/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.mc.event.ScreenInitEvent;
import com.wynntils.mc.event.SlotRenderEvent;
import com.wynntils.models.containers.Container;
import com.wynntils.models.containers.containers.CraftingStationContainer;
import com.wynntils.models.containers.containers.personal.PersonalStorageContainer;
import com.wynntils.models.containers.type.HighlightableProfessionProperty;
import com.wynntils.models.items.properties.ProfessionItemProperty;
import com.wynntils.models.profession.type.ProfessionType;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.UI)
public class ProfessionHighlightFeature
extends Feature {
    @Persisted
    private final Config<CustomColor> highlightColor = new Config<CustomColor>(new CustomColor(20, 89, 204));
    @Persisted
    private final Config<HighlightSelectionMode> selectionMode = new Config<HighlightSelectionMode>(HighlightSelectionMode.PER_CONTAINER);
    @Persisted
    private final Storage<ProfessionType> selectedProfession = new Storage<Object>(null);
    @Persisted
    private final Storage<Map<String, ProfessionType>> selectionPerContainer = new Storage(new TreeMap());

    @SubscribeEvent
    public void onScreenInit(ScreenInitEvent.Pre event) {
        Container container;
        Screen screen = event.getScreen();
        if (!(screen instanceof AbstractContainerScreen)) {
            return;
        }
        AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
        if (!(Models.Container.getCurrentContainer() instanceof HighlightableProfessionProperty)) {
            return;
        }
        if (this.selectedProfession.get() != null && this.selectionMode.get() == HighlightSelectionMode.GLOBAL && (container = Models.Container.getCurrentContainer()) instanceof CraftingStationContainer) {
            CraftingStationContainer craftingStation = (CraftingStationContainer)container;
            this.setSelectedProfession(craftingStation.getProfessionType());
        }
        int renderX = (screen.width - containerScreen.imageWidth) / 2;
        int renderY = (screen.height - containerScreen.imageHeight) / 2;
        this.addWidgets(containerScreen, renderX, renderY);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderSlot(SlotRenderEvent.Pre event) {
        Screen screen = event.getScreen();
        if (!(screen instanceof AbstractContainerScreen)) {
            return;
        }
        Container container = Models.Container.getCurrentContainer();
        if (!(container instanceof HighlightableProfessionProperty)) {
            return;
        }
        HighlightableProfessionProperty highlightableProfessionProperty = (HighlightableProfessionProperty)((Object)container);
        Slot slot = event.getSlot();
        if (!highlightableProfessionProperty.getBounds().getSlots().contains(slot.index)) {
            return;
        }
        Optional<ProfessionItemProperty> professionItemPropertyOpt = Models.Item.asWynnItemProperty(slot.getItem(), ProfessionItemProperty.class);
        if (professionItemPropertyOpt.isEmpty()) {
            return;
        }
        ProfessionType selectedProfession = this.getSelectedProfession();
        if (selectedProfession == null) {
            return;
        }
        if (!professionItemPropertyOpt.get().getProfessionTypes().contains(selectedProfession)) {
            return;
        }
        RenderSystem.enableDepthTest();
        RenderUtils.drawTexturedRectWithColor(event.getPoseStack(), Texture.HIGHLIGHT.resource(), (CustomColor)this.highlightColor.get(), slot.x - 1, slot.y - 1, 201.0f, 18.0f, 18.0f, Texture.HIGHLIGHT.width(), Texture.HIGHLIGHT.height());
        RenderSystem.disableDepthTest();
    }

    private void setSelectedProfession(ProfessionType professionType) {
        if (this.selectionMode.get() == HighlightSelectionMode.GLOBAL) {
            this.selectedProfession.store(professionType);
            return;
        }
        Container currentContainer = Models.Container.getCurrentContainer();
        if (currentContainer == null) {
            return;
        }
        Map containerSelection = (Map)this.selectionPerContainer.get();
        containerSelection.put(currentContainer.getContainerName(), professionType);
        this.selectionPerContainer.touched();
    }

    private ProfessionType getSelectedProfession() {
        if (this.selectionMode.get() == HighlightSelectionMode.GLOBAL) {
            return (ProfessionType)this.selectedProfession.get();
        }
        Container currentContainer = Models.Container.getCurrentContainer();
        if (currentContainer == null) {
            return null;
        }
        Map containerSelection = (Map)this.selectionPerContainer.get();
        return (ProfessionType)containerSelection.get(currentContainer.getContainerName());
    }

    private void addWidgets(AbstractContainerScreen<?> containerScreen, int renderX, int renderY) {
        renderX += containerScreen.imageWidth + 2;
        if (Models.Container.getCurrentContainer() instanceof PersonalStorageContainer) {
            renderX += 10;
        }
        containerScreen.addRenderableWidget((GuiEventListener)new ProfessionHighlightButton(renderX, renderY, 20, 20));
    }

    private static enum HighlightSelectionMode {
        PER_CONTAINER,
        GLOBAL;

    }

    private static final class ProfessionHighlightButton
    extends WynntilsButton {
        private ProfessionHighlightButton(int x, int y, int width, int height) {
            super(x, y, width, height, (Component)Component.empty());
        }

        public Component getMessage() {
            ProfessionHighlightFeature feature = Managers.Feature.getFeatureInstance(ProfessionHighlightFeature.class);
            ProfessionType profession = feature.getSelectedProfession();
            if (profession == null) {
                return Component.literal((String)"-");
            }
            return Component.literal((String)profession.getProfessionIconChar());
        }

        public void setFocused(boolean focused) {
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (!this.isMouseOver(mouseX, mouseY)) {
                return false;
            }
            ProfessionHighlightFeature feature = Managers.Feature.getFeatureInstance(ProfessionHighlightFeature.class);
            if (KeyboardUtils.isShiftDown()) {
                feature.setSelectedProfession(null);
                return true;
            }
            Object profession = feature.getSelectedProfession();
            Container container = Models.Container.getCurrentContainer();
            if (container instanceof CraftingStationContainer) {
                CraftingStationContainer craftingStation = (CraftingStationContainer)container;
                profession = profession == null ? craftingStation.getProfessionType() : null;
                feature.setSelectedProfession((ProfessionType)profession);
                return true;
            }
            if (button == 0) {
                int nextIndex;
                profession = profession == null ? ProfessionType.craftingProfessionTypes().getFirst() : ((nextIndex = (ProfessionType.craftingProfessionTypes().indexOf(profession) + 1) % ProfessionType.craftingProfessionTypes().size()) == 0 ? null : ProfessionType.craftingProfessionTypes().get(nextIndex));
                feature.setSelectedProfession((ProfessionType)profession);
                return true;
            }
            if (button == 1) {
                int nextIndex;
                profession = profession == null ? ProfessionType.craftingProfessionTypes().getLast() : ((nextIndex = (ProfessionType.craftingProfessionTypes().indexOf(profession) - 1) % ProfessionType.craftingProfessionTypes().size()) == -1 ? null : ProfessionType.craftingProfessionTypes().get(nextIndex));
                feature.setSelectedProfession((ProfessionType)profession);
                return true;
            }
            return false;
        }

        public void onPress() {
        }
    }
}

