/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.utilities;

import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.RegisterKeyBind;
import com.wynntils.core.keybinds.KeyBind;
import com.wynntils.core.mod.event.WynncraftConnectionEvent;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.mc.event.TitleScreenInitEvent;
import com.wynntils.utils.mc.McUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.OptionInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.UTILITIES)
public class SilencerFeature
extends Feature {
    @Persisted
    private final Config<Double> silencerVolume = new Config<Double>(0.01);
    @RegisterKeyBind
    private final KeyBind silencerKeyBind = new KeyBind("Toggle Silencer", -1, true, this::toggleSilencer);
    @Persisted
    private final Storage<Double> originalVolume = new Storage<Double>(1.0);
    private boolean isSilencerEnabled = false;
    private boolean firstTitleScreenInit = true;

    @SubscribeEvent
    public void onDisconnect(WynncraftConnectionEvent.Disconnected event) {
        if (this.isSilencerEnabled) {
            this.restoreOriginalVolume();
            this.isSilencerEnabled = false;
        }
    }

    @SubscribeEvent
    public void onTitleScreenInit(TitleScreenInitEvent.Pre event) {
        if (!this.firstTitleScreenInit) {
            return;
        }
        if (!((Double)this.masterVolume().get()).equals(this.silencerVolume.get())) {
            return;
        }
        this.restoreOriginalVolume();
        this.firstTitleScreenInit = false;
    }

    private void toggleSilencer() {
        if (!Models.WorldState.onWorld()) {
            return;
        }
        boolean bl = this.isSilencerEnabled = !this.isSilencerEnabled;
        if (this.isSilencerEnabled) {
            this.enableSilencer();
            Managers.Notification.queueMessage((Component)Component.translatable((String)"feature.wynntils.silencer.enabled").withStyle(ChatFormatting.GREEN));
        } else {
            this.restoreOriginalVolume();
            Managers.Notification.queueMessage((Component)Component.translatable((String)"feature.wynntils.silencer.disabled").withStyle(ChatFormatting.RED));
        }
    }

    private void restoreOriginalVolume() {
        this.masterVolume().set((Object)((Double)this.originalVolume.get()));
    }

    private void enableSilencer() {
        this.originalVolume.store((Double)this.masterVolume().get());
        this.masterVolume().set((Object)((Double)this.silencerVolume.get()));
    }

    private OptionInstance<Double> masterVolume() {
        return McUtils.options().getSoundSourceOptionInstance(SoundSource.MASTER);
    }
}

