/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.utilities;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.core.text.StyledTextPart;
import com.wynntils.core.text.type.StyleType;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.models.npcdialogue.event.NpcDialogueProcessingEvent;
import com.wynntils.models.wynnalphabet.WynnAlphabet;
import com.wynntils.models.wynnalphabet.type.TranscribeCondition;
import com.wynntils.utils.colors.ColorChatFormatting;
import com.wynntils.utils.type.IterationDecision;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Style;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.UTILITIES)
public class TranscribeMessagesFeature
extends Feature {
    @Persisted
    private final Config<Boolean> transcribeChat = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> transcribeNpcs = new Config<Boolean>(true);
    @Persisted
    private final Config<TranscribeCondition> transcribeCondition = new Config<TranscribeCondition>(TranscribeCondition.ALWAYS);
    @Persisted
    private final Config<Boolean> showTooltip = new Config<Boolean>(false);
    @Persisted
    private final Config<Boolean> coloredTranscriptions = new Config<Boolean>(true);
    @Persisted
    private final Config<ColorChatFormatting> gavellianColor = new Config<ColorChatFormatting>(ColorChatFormatting.LIGHT_PURPLE);
    @Persisted
    private final Config<ColorChatFormatting> wynnicColor = new Config<ColorChatFormatting>(ColorChatFormatting.DARK_GREEN);
    private static final Pattern END_OF_HEADER_PATTERN = Pattern.compile(".*:\\s?");

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onChat(ChatMessageEvent.Edit event) {
        StyledText modified;
        if (!((Boolean)this.transcribeChat.get()).booleanValue()) {
            return;
        }
        if (!Models.WynnAlphabet.hasWynnicOrGavellian(event.getMessage().getString())) {
            return;
        }
        boolean transcribeWynnic = Models.WynnAlphabet.shouldTranscribe((TranscribeCondition)((Object)this.transcribeCondition.get()), WynnAlphabet.WYNNIC);
        boolean transcribeGavellian = Models.WynnAlphabet.shouldTranscribe((TranscribeCondition)((Object)this.transcribeCondition.get()), WynnAlphabet.GAVELLIAN);
        if (!transcribeWynnic && !transcribeGavellian) {
            return;
        }
        StyledText message = event.getMessage();
        if (message.equals(modified = this.getStyledTextWithTranscription(message, transcribeWynnic, transcribeGavellian, false))) {
            return;
        }
        event.setMessage(modified);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onNpcDialogue(NpcDialogueProcessingEvent.Pre event) {
        if (!((Boolean)this.transcribeNpcs.get()).booleanValue()) {
            return;
        }
        boolean transcribeWynnic = Models.WynnAlphabet.shouldTranscribe((TranscribeCondition)((Object)this.transcribeCondition.get()), WynnAlphabet.WYNNIC);
        boolean transcribeGavellian = Models.WynnAlphabet.shouldTranscribe((TranscribeCondition)((Object)this.transcribeCondition.get()), WynnAlphabet.GAVELLIAN);
        if (!transcribeWynnic && !transcribeGavellian) {
            return;
        }
        event.addProcessingStep(future -> future.thenApply(styledTexts -> this.transcribeText((List<StyledText>)styledTexts, transcribeWynnic, transcribeGavellian)));
    }

    private List<StyledText> transcribeText(List<StyledText> styledTexts, boolean transcribeWynnic, boolean transcribeGavellian) {
        if (styledTexts.stream().noneMatch(text -> Models.WynnAlphabet.hasWynnicOrGavellian(text.getStringWithoutFormatting()))) {
            return styledTexts;
        }
        return styledTexts.stream().map(styledText -> this.getStyledTextWithTranscription((StyledText)styledText, transcribeWynnic, transcribeGavellian, true)).toList();
    }

    private StyledText getStyledTextWithTranscription(StyledText original, boolean transcribeWynnic, boolean transcribeGavellian, boolean npcDialogue) {
        if (!transcribeWynnic && !transcribeGavellian) {
            return original;
        }
        StyledText transcribedStyledText = original;
        if (transcribeWynnic) {
            transcribedStyledText = this.transcribeStyledText(transcribedStyledText, Models.WynnAlphabet::getWynnicNumberMatcher, partToBeTranslated -> Models.WynnAlphabet.transcribeMessageFromWynnAlphabet((StyledTextPart)partToBeTranslated, WynnAlphabet.WYNNIC, (Boolean)this.coloredTranscriptions.get(), ((ColorChatFormatting)((Object)((Object)this.wynnicColor.get()))).getChatFormatting(), !npcDialogue && (Boolean)this.showTooltip.get() != false));
            transcribedStyledText = this.transcribeStyledText(transcribedStyledText, Models.WynnAlphabet::getWynnicCharacterMatcher, partToBeTranslated -> Models.WynnAlphabet.transcribeMessageFromWynnAlphabet((StyledTextPart)partToBeTranslated, WynnAlphabet.WYNNIC, (Boolean)this.coloredTranscriptions.get(), ((ColorChatFormatting)((Object)((Object)this.wynnicColor.get()))).getChatFormatting(), !npcDialogue && (Boolean)this.showTooltip.get() != false));
        }
        if (transcribeGavellian) {
            transcribedStyledText = this.transcribeStyledText(transcribedStyledText, Models.WynnAlphabet::getGavellianCharacterMatcher, partToBeTranslated -> Models.WynnAlphabet.transcribeMessageFromWynnAlphabet((StyledTextPart)partToBeTranslated, WynnAlphabet.GAVELLIAN, (Boolean)this.coloredTranscriptions.get(), ((ColorChatFormatting)((Object)((Object)this.gavellianColor.get()))).getChatFormatting(), !npcDialogue && (Boolean)this.showTooltip.get() != false));
        }
        return transcribedStyledText;
    }

    private StyledText transcribeStyledText(StyledText original, Function<String, Matcher> matcherFunction, Function<StyledTextPart, StyledTextPart> transcriptorFunction) {
        return original.iterateBackwards((part, changes) -> {
            String partText;
            String transcriptedText = partText = part.getString(null, StyleType.NONE);
            if (END_OF_HEADER_PATTERN.matcher(partText).matches()) {
                return IterationDecision.BREAK;
            }
            List<StyledTextPart> newParts = new ArrayList<StyledTextPart>();
            if ((newParts = this.translatePartUsingMatcher((StyledTextPart)part, matcherFunction, transcriptorFunction, newParts)).isEmpty()) {
                return IterationDecision.CONTINUE;
            }
            changes.remove(part);
            changes.addAll(newParts);
            return IterationDecision.CONTINUE;
        });
    }

    private List<StyledTextPart> translatePartUsingMatcher(StyledTextPart part, Function<String, Matcher> matcherFunction, Function<StyledTextPart, StyledTextPart> transcriptorFunction, List<StyledTextPart> newParts) {
        String partText = part.getString(null, StyleType.NONE);
        Matcher matcher = matcherFunction.apply(partText);
        while (matcher.find()) {
            StyledTextPart partToBeTranslated = new StyledTextPart(matcher.group(), part.getPartStyle().getStyle(), null, Style.EMPTY);
            StyledTextPart transcribedPart = transcriptorFunction.apply(partToBeTranslated);
            if (matcher.start() > 0) {
                String preText = partText.substring(0, matcher.start());
                Style style = preText.isBlank() ? part.getPartStyle().getStyle().withColor(transcribedPart.getPartStyle().getStyle().getColor()) : part.getPartStyle().getStyle();
                newParts.add(new StyledTextPart(preText, style, null, Style.EMPTY));
            }
            newParts.add(transcribedPart);
            partText = partText.substring(matcher.end());
            matcher = matcherFunction.apply(partText);
        }
        if (!partText.isEmpty()) {
            newParts.add(new StyledTextPart(partText, part.getPartStyle().getStyle(), null, Style.EMPTY));
        }
        return newParts;
    }
}

