/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.utilities;

import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.notifications.MessageContainer;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.characterstats.event.CombatXpGainEvent;
import com.wynntils.models.profession.event.ProfessionXpGainEvent;
import com.wynntils.models.profession.type.ProfessionType;
import com.wynntils.models.worlds.event.WorldStateEvent;
import java.util.EnumMap;
import java.util.Map;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.UTILITIES)
public class XpGainMessageFeature
extends Feature {
    @Persisted
    private final Config<Boolean> combat = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> professions = new Config<Boolean>(true);
    @Persisted
    private final Config<Float> secondDelay = new Config<Float>(Float.valueOf(10.0f));
    @Persisted
    private final Config<Boolean> filterChat = new Config<Boolean>(true);
    private long lastCombatXpDisplayTime = 0L;
    private final Map<ProfessionType, Long> lastProfessionXpDisplayTimes = new EnumMap<ProfessionType, Long>(ProfessionType.class);
    private MessageContainer lastCombatMessage = null;
    private float lastRawCombatXpGain = 0.0f;
    private float currentCombatXpPercentage = 0.0f;
    private final Map<ProfessionType, MessageContainer> lastProfessionMessages = new EnumMap<ProfessionType, MessageContainer>(ProfessionType.class);
    private final Map<ProfessionType, Float> lastRawProfessionXpGains = new EnumMap<ProfessionType, Float>(ProfessionType.class);

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        this.lastCombatXpDisplayTime = 0L;
        for (ProfessionType profession : ProfessionType.values()) {
            this.lastProfessionXpDisplayTimes.put(profession, 0L);
        }
    }

    @SubscribeEvent
    public void onCombatXpGain(CombatXpGainEvent event) {
        if (!((Boolean)this.combat.get()).booleanValue() || !Models.WorldState.onWorld()) {
            return;
        }
        if (this.lastCombatMessage != null && this.shouldEditOldMessage(this.lastCombatXpDisplayTime)) {
            Managers.Notification.editMessage(this.lastCombatMessage, XpGainMessageFeature.getCombatXpGainMessage(this.lastRawCombatXpGain + event.getGainedXpRaw(), this.currentCombatXpPercentage + event.getGainedXpPercentage()));
            this.lastRawCombatXpGain += event.getGainedXpRaw();
            this.currentCombatXpPercentage += event.getGainedXpPercentage();
        } else {
            this.lastRawCombatXpGain = event.getGainedXpRaw();
            this.currentCombatXpPercentage = event.getGainedXpPercentage();
            this.lastCombatMessage = Managers.Notification.queueMessage(XpGainMessageFeature.getCombatXpGainMessage(event.getGainedXpRaw(), event.getGainedXpPercentage()));
        }
        this.lastCombatXpDisplayTime = System.currentTimeMillis();
    }

    @SubscribeEvent
    public void onProfessionXpGain(ProfessionXpGainEvent event) {
        if (!((Boolean)this.professions.get()).booleanValue() || !Models.WorldState.onWorld()) {
            return;
        }
        ProfessionType profession = event.getProfession();
        float lastRawXpGain = this.lastRawProfessionXpGains.getOrDefault(profession, Float.valueOf(0.0f)).floatValue();
        float currentXpPercentage = event.getCurrentXpPercentage();
        if (this.lastProfessionMessages.containsKey(profession) && this.shouldEditOldMessage(this.lastProfessionXpDisplayTimes.get(profession))) {
            Managers.Notification.editMessage(this.lastProfessionMessages.get(profession), XpGainMessageFeature.getProfessionXpGainMessage(profession, lastRawXpGain += event.getGainedXpRaw(), currentXpPercentage));
        } else {
            lastRawXpGain = event.getGainedXpRaw();
            this.lastProfessionMessages.put(profession, Managers.Notification.queueMessage(XpGainMessageFeature.getProfessionXpGainMessage(profession, lastRawXpGain, currentXpPercentage)));
        }
        this.lastRawProfessionXpGains.put(profession, Float.valueOf(lastRawXpGain));
        this.lastProfessionXpDisplayTimes.put(profession, System.currentTimeMillis());
        if (((Boolean)this.filterChat.get()).booleanValue()) {
            event.setCanceled(true);
        }
    }

    private boolean shouldEditOldMessage(long lastGainTime) {
        return (float)(System.currentTimeMillis() - lastGainTime) < ((Float)this.secondDelay.get()).floatValue() * 1000.0f;
    }

    private static StyledText getProfessionXpGainMessage(ProfessionType profession, float rawXpGain, float currentXpPercentage) {
        return StyledText.fromString(String.format("\u00a72+%.0f %s XP (\u00a76%.2f%%\u00a72)", Float.valueOf(rawXpGain), profession.getProfessionIconChar(), Float.valueOf(currentXpPercentage)));
    }

    private static StyledText getCombatXpGainMessage(float rawXpGain, float currentXpPercentage) {
        return StyledText.fromString(String.format("\u00a72+%.0f XP (\u00a76%.2f%%\u00a72)", Float.valueOf(rawXpGain), Float.valueOf(currentXpPercentage)));
    }
}

