/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.actionbar.event;

import com.wynntils.handlers.actionbar.ActionBarSegment;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.neoforged.bus.api.Event;

public class ActionBarRenderEvent
extends Event {
    private final Map<ActionBarSegment, Boolean> segments;
    private boolean renderCoordinates = true;

    public ActionBarRenderEvent(List<ActionBarSegment> segments) {
        this.segments = segments.stream().collect(Collectors.toMap(segment -> segment, segment -> true));
    }

    public Set<ActionBarSegment> getSegments() {
        return this.segments.keySet();
    }

    public Set<ActionBarSegment> getDisabledSegments() {
        return this.segments.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public void setSegmentEnabled(Class<? extends ActionBarSegment> segment, boolean enabled) {
        this.segments.keySet().stream().filter(segment::isInstance).map(segment::cast).findFirst().ifPresent(s -> this.segments.put((ActionBarSegment)s, enabled));
    }

    public boolean shouldRenderCoordinates() {
        return this.renderCoordinates;
    }

    public void setRenderCoordinates(boolean renderCoordinates) {
        this.renderCoordinates = renderCoordinates;
    }
}

