/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.chat;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handler;
import com.wynntils.core.components.Models;
import com.wynntils.core.mod.event.WynncraftConnectionEvent;
import com.wynntils.core.text.StyledText;
import com.wynntils.core.text.type.StyleType;
import com.wynntils.handlers.chat.ChatPageDetector;
import com.wynntils.handlers.chat.ChatPageProcessor;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.handlers.chat.type.MessageType;
import com.wynntils.handlers.chat.type.RecipientType;
import com.wynntils.mc.event.MobEffectEvent;
import com.wynntils.mc.event.SystemMessageEvent;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.utils.mc.McUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

public final class ChatHandler
extends Handler {
    private final ChatPageDetector pageDetector = new ChatPageDetector();
    private final ChatPageProcessor pageProcessor = new ChatPageProcessor();
    private boolean isLocal;

    @SubscribeEvent
    public void onConnectionChange(WynncraftConnectionEvent.Connected event) {
        this.pageDetector.reset();
        this.pageProcessor.reset();
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        this.pageDetector.reset();
        this.pageProcessor.reset();
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        this.pageDetector.onTick();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onSystemChatReceived(SystemMessageEvent.ChatReceivedEvent event) {
        boolean handled;
        if (this.needPageDetector() && (handled = this.pageDetector.processIncomingChatMessage(event))) {
            return;
        }
        this.handleIncomingChatMessage(event);
    }

    @SubscribeEvent
    public void onStatusEffectUpdate(MobEffectEvent.Update event) {
        this.pageProcessor.onStatusEffectUpdate(event);
    }

    @SubscribeEvent
    public void onStatusEffectRemove(MobEffectEvent.Remove event) {
        this.pageProcessor.onStatusEffectRemove(event);
    }

    void handlePage(List<StyledText> pageContent) {
        this.pageProcessor.handlePage(pageContent);
    }

    void sendDelayedChat(Component msg) {
        StyledText message = StyledText.fromComponent(msg);
        StyledText newMessage = this.processChatMessage(message, MessageType.FOREGROUND);
        if (newMessage == null) {
            return;
        }
        McUtils.mc().gui.getChat().addMessage((Component)newMessage.getComponent());
    }

    void handleBackgroundLine(StyledText message) {
        StyledText newMessage = this.processChatMessage(message, MessageType.BACKGROUND);
        if (newMessage == null) {
            return;
        }
        McUtils.mc().gui.getChat().addMessage((Component)newMessage.getComponent());
    }

    private void handleIncomingChatMessage(SystemMessageEvent.ChatReceivedEvent event) {
        StyledText message = StyledText.fromComponent(event.getMessage());
        StyledText newMessage = this.processChatMessage(message, MessageType.FOREGROUND);
        if (newMessage == null) {
            event.setCanceled(true);
            return;
        }
        if (!newMessage.equals(message)) {
            event.setMessage((Component)newMessage.getComponent());
        }
    }

    private StyledText processChatMessage(StyledText message, MessageType messageType) {
        RecipientType recipientType = this.getRecipientType(message, messageType);
        WynntilsMod.info("[CHAT/" + String.valueOf((Object)recipientType) + (messageType == MessageType.BACKGROUND ? "/bg" : "") + "] " + message.getString(StyleType.COMPLETE).replace("\u00a7", "&"));
        ChatMessageEvent.Match receivedEvent = new ChatMessageEvent.Match(message, messageType, recipientType);
        WynntilsMod.postEvent(receivedEvent);
        if (receivedEvent.isChatCanceled()) {
            return null;
        }
        ChatMessageEvent.Edit rewriteEvent = new ChatMessageEvent.Edit(message, messageType, recipientType);
        WynntilsMod.postEvent(rewriteEvent);
        return rewriteEvent.getMessage();
    }

    public RecipientType getRecipientType(StyledText codedMessage, MessageType messageType) {
        for (RecipientType recipientType : RecipientType.values()) {
            if (!recipientType.matchPattern(codedMessage, messageType)) continue;
            return recipientType;
        }
        return RecipientType.INFO;
    }

    private boolean needPageDetector() {
        return Models.NpcDialogue.isNpcDialogExtractionRequired();
    }

    public void setLocalMessage(boolean isLocal) {
        this.isLocal = isLocal;
    }

    public boolean isLocalMessage() {
        return this.isLocal;
    }
}

