/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.chat;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.chat.type.NpcDialogueType;
import com.wynntils.mc.event.MobEffectEvent;
import com.wynntils.utils.mc.McUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.world.effect.MobEffects;

public final class ChatPageProcessor {
    private static final Pattern NPC_CONFIRM_PATTERN = Pattern.compile("^ *\u00a7[47]Press \u00a7[cf](SNEAK|SHIFT) \u00a7[47]to continue$");
    private static final Pattern NPC_SELECT_PATTERN = Pattern.compile("^ *\u00a7[47cf](Select|CLICK) \u00a7[47cf]an option (\u00a7[47])?to continue$");
    private static final Pattern EMPTY_LINE_PATTERN = Pattern.compile("^\\s*(\u00a7r|\u00c0+)?\\s*$");
    private boolean isProtected = false;

    public void onStatusEffectUpdate(MobEffectEvent.Update event) {
        if (event.getEntity() != McUtils.player()) {
            return;
        }
        if (event.getEffect().equals(MobEffects.MOVEMENT_SLOWDOWN.value()) && event.getEffectAmplifier() == 3 && event.getEffectDurationTicks() == Short.MAX_VALUE) {
            this.isProtected = true;
        }
    }

    public void onStatusEffectRemove(MobEffectEvent.Remove event) {
        if (event.getEntity() != McUtils.player()) {
            return;
        }
        if (event.getEffect().equals(MobEffects.MOVEMENT_SLOWDOWN.value())) {
            this.isProtected = false;
        }
    }

    public void handlePage(List<StyledText> page) {
        NpcDialogueType type = NpcDialogueType.NONE;
        ArrayList<StyledText> pageContent = new ArrayList<StyledText>(page);
        if (!pageContent.isEmpty()) {
            while (pageContent.getFirst().isBlank()) {
                pageContent.removeFirst();
            }
            while (pageContent.getLast().isBlank()) {
                pageContent.removeLast();
            }
            StyledText lastLine = pageContent.getLast();
            if (lastLine.find(NPC_SELECT_PATTERN)) {
                type = NpcDialogueType.SELECTION;
            } else if (lastLine.find(NPC_CONFIRM_PATTERN)) {
                type = NpcDialogueType.NORMAL;
            } else {
                while (!pageContent.isEmpty() && (pageContent.getFirst().find(EMPTY_LINE_PATTERN) || pageContent.getFirst().isBlank())) {
                    pageContent.removeFirst();
                }
                type = pageContent.isEmpty() ? NpcDialogueType.NONE : NpcDialogueType.CONFIRMATIONLESS;
            }
            if (type == NpcDialogueType.SELECTION || type == NpcDialogueType.NORMAL) {
                pageContent.removeLast();
                if (!pageContent.isEmpty() && pageContent.getLast().isBlank()) {
                    pageContent.removeLast();
                } else {
                    WynntilsMod.warn("Malformed dialog [#3]: " + String.valueOf(lastLine));
                }
            }
        }
        Models.NpcDialogue.handleDialogue(pageContent, this.isProtected, type);
    }

    public void reset() {
        this.isProtected = false;
    }
}

